/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.dynamo;

import cofh.network.Payload;
import cofh.util.ItemHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.NetHandler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.dynamo.BlockDynamo;
import thermalexpansion.block.dynamo.TileDynamoBase;
import thermalexpansion.core.TEProps;

public class TileDynamoReactant
extends TileDynamoBase
implements IFluidHandler {
    static int sugarRF = 16000;
    static int gunpowderRF = 160000;
    static int blazePowderRF = 640000;
    static int ghastTearRF = 1600000;
    static int netherStarRF = 6400000;
    static ItemStack sugar = new ItemStack(Item.field_77747_aY, 1, 0);
    static ItemStack gunpowder = new ItemStack(Item.field_77677_M, 1, 0);
    static ItemStack blazePowder = new ItemStack(Item.field_77722_bw, 1, 0);
    static ItemStack ghastTear = new ItemStack(Item.field_77732_bp, 1, 0);
    static ItemStack netherStar = new ItemStack(Item.field_82792_bS, 1, 0);
    static Map fuels = new HashMap();
    FluidTank tank = new FluidTank(4000);
    FluidStack renderFluid = new FluidStack(FluidRegistry.LAVA, 1000);
    int reactantRF;
    int currentReactantRF;

    public static void initialize() {
        TileDynamoReactant.guiIds[BlockDynamo.Types.REACTANT.ordinal()] = ThermalExpansion.proxy.registerGui("DynamoReactant", "dynamo", true);
        GameRegistry.registerTileEntity(TileDynamoReactant.class, (String)"cofh.thermalexpansion.DynamoReactant");
    }

    public TileDynamoReactant() {
        this.inventory = new ItemStack[1];
    }

    public int getType() {
        return BlockDynamo.Types.REACTANT.ordinal();
    }

    public static boolean registerFuel(Fluid fluid, int energy) {
        if (fluid == null || energy <= 10000) {
            return false;
        }
        fuels.put(fluid, energy / 100);
        return true;
    }

    public static int getFuelEnergy(FluidStack stack) {
        return stack == null ? 0 : (Integer)fuels.get(stack.getFluid());
    }

    public static boolean isValidFuel(FluidStack stack) {
        return stack == null ? false : fuels.containsKey(stack.getFluid());
    }

    public static int getItemEnergyValue(ItemStack reactant) {
        if (reactant == null) {
            return 0;
        }
        if (reactant.func_77969_a(sugar)) {
            return sugarRF;
        }
        if (reactant.func_77969_a(gunpowder)) {
            return gunpowderRF;
        }
        if (reactant.func_77969_a(blazePowder)) {
            return blazePowderRF;
        }
        if (reactant.func_77969_a(ghastTear)) {
            return ghastTearRF;
        }
        if (reactant.func_77969_a(netherStar)) {
            return netherStarRF;
        }
        return 0;
    }

    public FluidTank getTank(int tankIndex) {
        return this.tank;
    }

    @Override
    protected boolean canGenerate() {
        if (this.fuelRF > 0) {
            return this.reactantRF > 0 || TileDynamoReactant.getItemEnergyValue(this.inventory[0]) > 0;
        }
        if (this.reactantRF > 0) {
            return this.tank.getFluidAmount() >= 10;
        }
        return this.tank.getFluidAmount() >= 10 && TileDynamoReactant.getItemEnergyValue(this.inventory[0]) > 0;
    }

    @Override
    protected void generate() {
        int energy;
        if (this.fuelRF <= 0) {
            this.fuelRF = TileDynamoReactant.getFuelEnergy(this.tank.getFluid());
            this.tank.drain(10, true);
        }
        if (this.reactantRF <= 0) {
            energy = TileDynamoReactant.getItemEnergyValue(this.inventory[0]);
            this.reactantRF += energy;
            this.currentReactantRF = energy;
            this.inventory[0] = ItemHelper.consumeItem((ItemStack)this.inventory[0]);
        }
        energy = this.calcEnergy();
        this.energyStorage.modifyEnergyStored(energy);
        this.fuelRF -= energy;
        this.reactantRF -= energy;
    }

    @Override
    public Icon getActiveIcon() {
        return this.renderFluid.getFluid().getIcon();
    }

    @Override
    public Payload getDescriptionPayload() {
        Payload payload = super.getDescriptionPayload();
        payload.addFluidStack(this.tank.getFluid());
        return payload;
    }

    @Override
    public Payload getGuiPayload() {
        Payload payload = Payload.getInfoPayload((TileEntity)this);
        payload.addByte(TEProps.PacketID.GUI.ordinal());
        payload.addFluidStack(this.tank.getFluid());
        payload.addInt(this.energyStorage.getEnergyStored());
        payload.addInt(this.reactantRF);
        payload.addInt(this.currentReactantRF);
        return payload;
    }

    @Override
    public void handleTilePacket(Payload payload) {
        super.handleTilePacket(payload);
        this.renderFluid = payload.getFluidStack();
        if (this.renderFluid == null) {
            this.renderFluid = new FluidStack(FluidRegistry.LAVA, 1000);
        }
    }

    @Override
    public void handleTileInfoPacket(Payload payload, NetHandler handler) {
        switch (TEProps.PacketID.values()[payload.getByte()]) {
            case GUI: {
                this.tank.setFluid(payload.getFluidStack());
                this.energyStorage.setEnergyStored(payload.getInt());
                this.reactantRF = payload.getInt();
                this.currentReactantRF = payload.getInt();
                return;
            }
        }
    }

    public int getScaledDuration(int scale) {
        if (this.currentReactantRF <= 0) {
            this.currentReactantRF = sugarRF;
        }
        return this.reactantRF * scale / this.currentReactantRF;
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.currentReactantRF = nbt.func_74762_e("ReactMax");
        this.reactantRF = nbt.func_74762_e("React");
        this.tank.readFromNBT(nbt);
        if (!TileDynamoReactant.isValidFuel(this.tank.getFluid())) {
            this.tank.setFluid(null);
        }
        if (this.tank.getFluid() != null) {
            this.renderFluid = this.tank.getFluid();
        }
        if (this.currentReactantRF <= 0) {
            this.currentReactantRF = sugarRF;
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74768_a("ReactMax", this.currentReactantRF);
        nbt.func_74768_a("React", this.reactantRF);
        this.tank.writeToNBT(nbt);
    }

    @Override
    public int[] func_94128_d(int side) {
        return side != this.facing ? SLOTS : TEProps.EMPTY_INVENTORY;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource == null || from != ForgeDirection.UNKNOWN && from.ordinal() == this.facing) {
            return 0;
        }
        if (TileDynamoReactant.isValidFuel(resource)) {
            return this.tank.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null || from != ForgeDirection.UNKNOWN && from.ordinal() == this.facing) {
            return null;
        }
        if (TileDynamoReactant.isValidFuel(resource)) {
            return this.tank.drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return from.ordinal() != this.facing;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return from.ordinal() != this.facing;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }
}

