/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.machine;

import cofh.network.Payload;
import cofh.render.IconRegistry;
import cofh.render.RenderHelper;
import cofh.util.FluidHelper;
import cofh.util.ServerHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.NetHandler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.machine.BlockMachine;
import thermalexpansion.block.machine.TileMachineBase;
import thermalexpansion.block.machine.TileMachineEnergized;
import thermalexpansion.core.TEProps;
import thermalexpansion.util.crafting.CrucibleManager;

public class TileCrucible
extends TileMachineEnergized
implements IFluidHandler {
    public static final int TYPE = BlockMachine.Types.CRUCIBLE.ordinal();
    FluidStack renderFluid = new FluidStack(FluidRegistry.LAVA, 0);
    FluidTank tank = new FluidTank(10000);
    FluidStack outputBuffer;
    int outputTrackerFluid;

    public static void initialize() {
        TileCrucible.sideData[TileCrucible.TYPE] = new TileMachineBase.SideConfig();
        TileCrucible.sideData[TileCrucible.TYPE].numGroup = 3;
        TileCrucible.sideData[TileCrucible.TYPE].slotGroups = new int[][]{new int[0], {0}, new int[0]};
        TileCrucible.sideData[TileCrucible.TYPE].allowInsertion = new boolean[]{false, true, false};
        TileCrucible.sideData[TileCrucible.TYPE].allowExtraction = new boolean[]{false, false, false};
        TileCrucible.sideData[TileCrucible.TYPE].sideTex = new int[]{0, 1, 4};
        TileCrucible.energyData[TileCrucible.TYPE] = new TileMachineEnergized.EnergyConfig();
        energyData[TYPE].setEnergyParams(40, 400, 400000);
        TileCrucible.guiIds[TileCrucible.TYPE] = ThermalExpansion.proxy.registerGui("Crucible", "machine", true);
        GameRegistry.registerTileEntity(TileCrucible.class, (String)"cofh.thermalexpansion.Crucible");
    }

    public TileCrucible() {
        this.sideCache = new byte[]{1, 1, 2, 2, 2, 2};
        this.inventory = new ItemStack[2];
    }

    public int getType() {
        return TYPE;
    }

    @Override
    public boolean canStart() {
        if (this.inventory[0] == null) {
            return false;
        }
        CrucibleManager.RecipeCrucible recipe = CrucibleManager.getRecipe(this.inventory[0]);
        if (recipe == null || this.energyStorage.getEnergyStored() < recipe.getEnergy()) {
            return false;
        }
        if (this.inventory[0].field_77994_a < recipe.getInput().field_77994_a) {
            return false;
        }
        FluidStack output = recipe.getOutput();
        return this.tank.fill(output, false) == output.amount;
    }

    @Override
    protected boolean hasValidInput() {
        CrucibleManager.RecipeCrucible recipe = CrucibleManager.getRecipe(this.inventory[0]);
        return recipe == null ? false : recipe.getInput().field_77994_a <= this.inventory[0].field_77994_a;
    }

    @Override
    protected void processStart() {
        this.processRem = this.processMax = CrucibleManager.getRecipe(this.inventory[0]).getEnergy();
        int prevID = this.renderFluid.fluidID;
        this.renderFluid = CrucibleManager.getRecipe(this.inventory[0]).getOutput();
        this.renderFluid.amount = 0;
        if (prevID != this.renderFluid.fluidID) {
            this.sendFluidPacket();
        }
    }

    @Override
    protected void processFinish() {
        this.tank.fill(CrucibleManager.getRecipe(this.inventory[0]).getOutput(), true);
        --this.inventory[0].field_77994_a;
        if (this.inventory[0].field_77994_a <= 0) {
            this.inventory[0] = null;
        }
    }

    protected void transferFluid() {
        if (this.tank.getFluidAmount() <= 0) {
            return;
        }
        this.outputBuffer = new FluidStack(this.tank.getFluid(), Math.min(this.tank.getFluidAmount(), 25));
        for (int i = this.outputTrackerFluid + 1; i <= this.outputTrackerFluid + 6; ++i) {
            int toDrain;
            int side = i % 6;
            if (this.sideCache[side] != 2 || (toDrain = FluidHelper.insertFluidIntoAdjacentFluidHandler((TileEntity)this, (int)side, (FluidStack)this.outputBuffer, (boolean)true)) <= 0) continue;
            this.tank.drain(toDrain, true);
            this.outputTrackerFluid = side;
            break;
        }
    }

    @Override
    public void func_70316_g() {
        if (ServerHelper.isClientWorld((World)this.field_70331_k)) {
            return;
        }
        this.transferFluid();
        super.func_70316_g();
    }

    @Override
    public boolean canAcceptItem(ItemStack stack, int slot, int side) {
        return slot == 0 ? CrucibleManager.recipeExists(stack) : true;
    }

    @Override
    public Payload getDescriptionPayload() {
        Payload payload = super.getDescriptionPayload();
        payload.addFluidStack(this.renderFluid);
        return payload;
    }

    @Override
    public Payload getGuiPayload() {
        Payload payload = super.getGuiPayload();
        if (this.tank.getFluid() == null) {
            payload.addFluidStack(this.renderFluid);
        } else {
            payload.addFluidStack(this.tank.getFluid());
        }
        return payload;
    }

    @Override
    public Payload getFluidPayload() {
        Payload payload = super.getFluidPayload();
        payload.addFluidStack(this.renderFluid);
        return payload;
    }

    @Override
    public void handleTilePacket(Payload payload) {
        super.handleTilePacket(payload);
        if (ServerHelper.isClientWorld((World)this.field_70331_k)) {
            this.renderFluid = payload.getFluidStack();
        } else {
            payload.getFluidStack();
        }
    }

    @Override
    public void handleTileInfoPacket(Payload payload, NetHandler handler) {
        switch (TEProps.PacketID.values()[payload.getByte()]) {
            case GUI: {
                this.isActive = payload.getBool();
                this.processMax = payload.getInt();
                this.processRem = payload.getInt();
                this.energyStorage.setEnergyStored(payload.getInt());
                this.tank.setFluid(payload.getFluidStack());
                return;
            }
            case FLUID: {
                this.renderFluid = payload.getFluidStack();
                this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
                return;
            }
        }
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public FluidStack getTankFluid() {
        return this.tank.getFluid();
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.outputTrackerFluid = nbt.func_74762_e("Tracker");
        this.tank.readFromNBT(nbt);
        if (this.tank.getFluid() != null) {
            this.renderFluid = this.tank.getFluid();
        } else if (CrucibleManager.getRecipe(this.inventory[0]) != null) {
            this.renderFluid = CrucibleManager.getRecipe(this.inventory[0]).getOutput();
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74768_a("Tracker", this.outputTrackerFluid);
        this.tank.writeToNBT(nbt);
    }

    @Override
    public Icon getBlockTexture(int side, int pass) {
        if (pass == 0) {
            if (side == 0) {
                return IconRegistry.getIcon((String)"MachineBottom");
            }
            if (side == 1) {
                return IconRegistry.getIcon((String)"MachineTop");
            }
            return side != this.facing ? IconRegistry.getIcon((String)"MachineSide") : (this.isActive ? RenderHelper.getFluidTexture((FluidStack)this.renderFluid) : IconRegistry.getIcon((String)"MachineFace_", (int)this.getType()));
        }
        return side != this.facing ? IconRegistry.getIcon((String)TEProps.textureSelection, (int)TileCrucible.sideData[this.getType()].sideTex[this.sideCache[side]]) : (this.isActive ? IconRegistry.getIcon((String)"MachineActive_", (int)this.getType()) : IconRegistry.getIcon((String)"MachineFace_", (int)this.getType()));
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (from == ForgeDirection.UNKNOWN || this.sideCache[from.ordinal()] != 2) {
            return null;
        }
        if (resource == null || !resource.isFluidEqual(this.tank.getFluid())) {
            return null;
        }
        return this.tank.drain(resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (from != ForgeDirection.UNKNOWN && this.sideCache[from.ordinal()] != 2) {
            return null;
        }
        return this.tank.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }
}

