/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.machine;

import cofh.network.ITileInfoPacketHandler;
import cofh.network.ITilePacketHandler;
import cofh.network.PacketUtils;
import cofh.network.Payload;
import cofh.render.IconRegistry;
import cofh.util.BlockHelper;
import cofh.util.ServerHelper;
import cofh.util.TimeTracker;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.NetHandler;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.TileReconfigurableInventory;
import thermalexpansion.block.machine.BlockMachine;
import thermalexpansion.core.TEProps;

public abstract class TileMachineBase
extends TileReconfigurableInventory
implements ISidedInventory,
ITilePacketHandler,
ITileInfoPacketHandler {
    protected static final SideConfig[] sideData = new SideConfig[BlockMachine.Types.values().length];
    protected static final int[] guiIds = new int[BlockMachine.Types.values().length];
    protected static final int[] LIGHT_VALUE = new int[]{14, 0, 0, 15, 15, 0, 0, 14, 0, 0, 7};
    protected static final int CHANCE = 100;
    protected static final int RATE = 25;
    protected static final int MAX_FLUID_SMALL = 4000;
    protected static final int MAX_FLUID_LARGE = 10000;
    TimeTracker tracker = new TimeTracker();
    boolean wasActive;
    int processMax;
    int processRem;

    public int getMaxInputSlot() {
        return 0;
    }

    public void updateIfChanged(boolean curActive) {
        if (curActive != this.isActive && this.isActive) {
            this.sendUpdatePacket(Side.CLIENT);
        } else if (this.tracker.hasDelayPassed(this.field_70331_k, 200) && this.wasActive) {
            this.wasActive = false;
            this.sendUpdatePacket(Side.CLIENT);
        }
    }

    public int getLightValue() {
        return this.isActive ? LIGHT_VALUE[this.getType()] : 0;
    }

    public String getName() {
        return "tile.thermalexpansion.machine." + BlockMachine.NAMES[this.getType()] + ".name";
    }

    public Payload getGuiPayload() {
        Payload payload = Payload.getInfoPayload((TileEntity)this);
        payload.addByte(TEProps.PacketID.GUI.ordinal());
        payload.addBool(this.isActive);
        payload.addInt(this.processMax);
        payload.addInt(this.processRem);
        return payload;
    }

    public Payload getFluidPayload() {
        Payload payload = Payload.getInfoPayload((TileEntity)this);
        payload.addByte(TEProps.PacketID.FLUID.ordinal());
        return payload;
    }

    public Payload getModePayload() {
        Payload payload = Payload.getInfoPayload((TileEntity)this);
        payload.addByte(TEProps.PacketID.MODE.ordinal());
        return payload;
    }

    public void sendFluidPacket() {
        PacketUtils.sendToAllPlayers((Packet)this.getFluidPayload().getPacket(), (World)this.field_70331_k);
    }

    public void sendModePacket() {
        if (ServerHelper.isClientWorld((World)this.field_70331_k)) {
            PacketUtils.sendToServer((Packet)this.getModePayload().getPacket());
        }
    }

    public void handleTileInfoPacket(Payload payload, NetHandler handler) {
        switch (TEProps.PacketID.values()[payload.getByte()]) {
            case GUI: {
                this.isActive = payload.getBool();
                this.processMax = payload.getInt();
                this.processRem = payload.getInt();
                return;
            }
        }
    }

    public boolean openGui(EntityPlayer player) {
        player.openGui((Object)ThermalExpansion.instance, guiIds[this.getType()], this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        return true;
    }

    public int getScaledProgress(int scale) {
        if (!this.isActive || this.processMax <= 0 || this.processRem <= 0) {
            return 0;
        }
        return scale * (this.processMax - this.processRem) / this.processMax;
    }

    public void sendGuiNetworkData(Container container, ICrafting iCrafting) {
        if (iCrafting instanceof EntityPlayer && ServerHelper.isServerWorld((World)this.field_70331_k)) {
            PacketUtils.sendToPlayer((Packet)this.getGuiPayload().getPacket(), (EntityPlayer)((EntityPlayer)iCrafting));
        }
    }

    public boolean canAcceptItem(ItemStack stack, int slot, int side) {
        return true;
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.processMax = nbt.func_74762_e("ProcMax");
        this.processRem = nbt.func_74762_e("ProcRem");
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74768_a("ProcMax", this.processMax);
        nbt.func_74768_a("ProcRem", this.processRem);
    }

    @Override
    public boolean setFacing(int side) {
        if (side < 0 || side > 5) {
            return false;
        }
        this.sideCache[side] = 0;
        this.sideCache[BlockHelper.SIDE_LEFT[side]] = 1;
        this.sideCache[BlockHelper.SIDE_OPPOSITE[side]] = 1;
        this.facing = (byte)side;
        this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.getBlockID());
        this.sendUpdatePacket(Side.CLIENT);
        return true;
    }

    @Override
    public int getNumConfig(int side) {
        return TileMachineBase.sideData[this.getType()].numGroup;
    }

    @Override
    public Icon getBlockTexture(int side, int pass) {
        if (pass == 0) {
            if (side == 0) {
                return IconRegistry.getIcon((String)"MachineBottom");
            }
            if (side == 1) {
                return IconRegistry.getIcon((String)"MachineTop");
            }
            return side != this.facing ? IconRegistry.getIcon((String)"MachineSide") : (this.isActive ? IconRegistry.getIcon((String)"MachineActive_", (int)this.getType()) : IconRegistry.getIcon((String)"MachineFace_", (int)this.getType()));
        }
        if (side < 6) {
            return IconRegistry.getIcon((String)TEProps.textureSelection, (int)TileMachineBase.sideData[this.getType()].sideTex[this.sideCache[side]]);
        }
        return IconRegistry.getIcon((String)"MachineSide");
    }

    public int[] func_94128_d(int side) {
        return TileMachineBase.sideData[this.getType()].slotGroups[this.sideCache[side]];
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return TileMachineBase.sideData[this.getType()].allowInsertion[this.sideCache[side]] ? this.canAcceptItem(stack, slot, side) : false;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return TileMachineBase.sideData[this.getType()].allowExtraction[this.sideCache[side]];
    }

    public static class SideConfig {
        public int numGroup;
        public int[][] slotGroups;
        public boolean[] allowInsertion;
        public boolean[] allowExtraction;
        public int[] sideTex;
    }
}

