/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.core;

import cofh.render.IconRegistry;
import cofh.render.ItemRenderRegistry;
import cofh.render.RenderItemAsBlock;
import cofh.render.RenderItemModular;
import cofh.util.StringHelper;
import cofh.util.version.TickHandlerVersion;
import cofh.util.version.VersionHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.IScheduledTickHandler;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.logging.Level;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderSnowball;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.event.sound.SoundLoadEvent;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.fluids.Fluid;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.ender.BlockTesseract;
import thermalexpansion.block.energycell.BlockEnergyCell;
import thermalexpansion.block.lamp.BlockLamp;
import thermalexpansion.block.machine.BlockMachine;
import thermalexpansion.core.Proxy;
import thermalexpansion.core.TEProps;
import thermalexpansion.entity.projectile.EntityBlizzBall;
import thermalexpansion.entity.projectile.EntityBlizzSpike;
import thermalexpansion.fluid.TEFluids;
import thermalexpansion.gui.client.ender.GuiTesseract;
import thermalexpansion.gui.element.ElementSlotOverlay;
import thermalexpansion.item.TEItems;
import thermalexpansion.part.conduit.GridTickHandler;
import thermalexpansion.part.conduit.ItemConduitPart;
import thermalexpansion.part.conduit.fluid.HUDModuleFluid;
import thermalexpansion.part.conduit.item.HUDModuleStuffedItem;
import thermalexpansion.render.RenderConduit;
import thermalexpansion.render.RenderDynamo;
import thermalexpansion.render.RenderEnergyCell;
import thermalexpansion.render.RenderItemFlorb;
import thermalexpansion.render.RenderLamp;
import thermalexpansion.render.RenderPlate;
import thermalexpansion.render.RenderSchematic;
import thermalexpansion.render.RenderStrongbox;
import thermalexpansion.render.RenderTank;
import thermalexpansion.render.RenderTesseract;
import thermalexpansion.render.entity.RenderEntityBlizz;
import thermalexpansion.render.entity.RenderEntityFlorb;
import thermalexpansion.util.TickHandlerClientConfig;
import thermalexpansion.util.Utils;

public class ProxyClient
extends Proxy {
    public static RenderItemModular rendererComponent = new RenderItemModular();
    public static RenderItemFlorb rendererFlorb = new RenderItemFlorb();

    @Override
    public void registerRenderInformation() {
        ElementSlotOverlay.enableBorders = TEProps.enableGuiBorders;
        MinecraftForgeClient.registerItemRenderer((int)TEItems.itemComponent.field_77779_bT, (IItemRenderer)rendererComponent);
        MinecraftForgeClient.registerItemRenderer((int)ItemConduitPart.itemConduit.field_77779_bT, (IItemRenderer)rendererComponent);
        MinecraftForgeClient.registerItemRenderer((int)TEItems.diagramSchematic.field_77993_c, (IItemRenderer)rendererComponent);
        MinecraftForgeClient.registerItemRenderer((int)TEFluids.itemFlorb.field_77779_bT, (IItemRenderer)rendererFlorb);
        ItemRenderRegistry.addItemRenderer((ItemStack)BlockMachine.machineFrame, (IItemRenderer)RenderItemAsBlock.instance);
        ItemRenderRegistry.addItemRenderer((ItemStack)BlockEnergyCell.cellBasicFrame, (IItemRenderer)RenderEnergyCell.instance);
        ItemRenderRegistry.addItemRenderer((ItemStack)BlockEnergyCell.cellReinforcedFrameEmpty, (IItemRenderer)RenderEnergyCell.instance);
        ItemRenderRegistry.addItemRenderer((ItemStack)BlockEnergyCell.cellReinforcedFrameFull, (IItemRenderer)RenderEnergyCell.instance);
        ItemRenderRegistry.addItemRenderer((ItemStack)BlockTesseract.tesseractFrameEmpty, (IItemRenderer)RenderTesseract.instance);
        ItemRenderRegistry.addItemRenderer((ItemStack)BlockTesseract.tesseractFrameFull, (IItemRenderer)RenderTesseract.instance);
        ItemRenderRegistry.addItemRenderer((ItemStack)BlockLamp.lampFrame, (IItemRenderer)RenderItemAsBlock.instance);
        ItemRenderRegistry.addItemRenderer((ItemStack)ItemConduitPart.conduitEnergyReinforcedEmpty, (IItemRenderer)RenderConduit.instance);
        ItemRenderRegistry.addItemRenderer((ItemStack)ItemConduitPart.conduitEnergyBasic, (IItemRenderer)RenderConduit.instance);
        ItemRenderRegistry.addItemRenderer((ItemStack)ItemConduitPart.conduitEnergyHardened, (IItemRenderer)RenderConduit.instance);
        ItemRenderRegistry.addItemRenderer((ItemStack)ItemConduitPart.conduitEnergyReinforced, (IItemRenderer)RenderConduit.instance);
        ItemRenderRegistry.addItemRenderer((ItemStack)ItemConduitPart.conduitFluidOpaque, (IItemRenderer)RenderConduit.instance);
        ItemRenderRegistry.addItemRenderer((ItemStack)ItemConduitPart.conduitFluidTrans, (IItemRenderer)RenderConduit.instance);
        ItemRenderRegistry.addItemRenderer((ItemStack)ItemConduitPart.conduitItemOpaque, (IItemRenderer)RenderConduit.instance);
        ItemRenderRegistry.addItemRenderer((ItemStack)ItemConduitPart.conduitItemFastOpaque, (IItemRenderer)RenderConduit.instance);
        ItemRenderRegistry.addItemRenderer((ItemStack)ItemConduitPart.conduitItemTrans, (IItemRenderer)RenderConduit.instance);
        ItemRenderRegistry.addItemRenderer((ItemStack)ItemConduitPart.conduitItemFastTrans, (IItemRenderer)RenderConduit.instance);
        ItemRenderRegistry.addItemRenderer((ItemStack)TEItems.diagramSchematic, (IItemRenderer)RenderSchematic.instance);
        RenderingRegistry.registerEntityRenderingHandler(EntityBlizzBall.class, (Render)new RenderSnowball(Item.field_77768_aD));
        RenderingRegistry.registerEntityRenderingHandler(EntityBlizzSpike.class, (Render)new RenderSnowball(Item.field_77768_aD));
    }

    @Override
    public void registerTickHandlers() {
        HUDModuleFluid.initialize();
        HUDModuleStuffedItem.initialize();
        TickRegistry.registerTickHandler((ITickHandler)GridTickHandler.instance, (Side)Side.SERVER);
        TickRegistry.registerTickHandler((ITickHandler)GridTickHandler.ItemClientTickHandler.instance, (Side)Side.CLIENT);
        if (ThermalExpansion.version.isMinecraftOutdated()) {
            return;
        }
        if (!TEProps.enableUpdateNotice && !ThermalExpansion.version.isCriticalUpdate()) {
            return;
        }
        TickHandlerVersion.registerModVersionInfo((VersionHandler)ThermalExpansion.version);
        if (!TickHandlerVersion.isInitialized()) {
            TickRegistry.registerScheduledTickHandler((IScheduledTickHandler)TickHandlerVersion.instance, (Side)Side.CLIENT);
            TickHandlerVersion.initialize();
        }
        TickRegistry.registerTickHandler((ITickHandler)TickHandlerClientConfig.instance, (Side)Side.CLIENT);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @ForgeSubscribe
    public void registerIcons(TextureStitchEvent.Pre event) {
        if (event.map.field_94255_a == 0) {
            ProxyClient.registerFluidIcons(TEFluids.fluidSteam, (IconRegister)event.map);
        } else if (event.map.field_94255_a == 1) {
            IconRegistry.addIcon((String)"machineFrame", (String)"thermalexpansion:component/MachineFrame", (IconRegister)event.map);
            IconRegistry.addIcon((String)"lampFrame", (String)"thermalexpansion:component/LampFrame", (IconRegister)event.map);
            IconRegistry.addIcon((String)"IconConfigMachine", (String)"thermalexpansion:icons/Icon_Config_Machine", (IconRegister)event.map);
            IconRegistry.addIcon((String)"IconConfigTesseract", (String)"thermalexpansion:icons/Icon_Config_Tesseract", (IconRegister)event.map);
            IconRegistry.addIcon((String)"IconRecvOnly", (String)"thermalexpansion:icons/Icon_RecvOnly", (IconRegister)event.map);
            IconRegistry.addIcon((String)"IconSendOnly", (String)"thermalexpansion:icons/Icon_SendOnly", (IconRegister)event.map);
            IconRegistry.addIcon((String)"IconSendRecv", (String)"thermalexpansion:icons/Icon_SendRecv", (IconRegister)event.map);
            IconRegistry.addIcon((String)"IconBlocked", (String)"thermalexpansion:icons/Icon_Blocked", (IconRegister)event.map);
            IconRegistry.addIcon((String)"IconSlotSchematic", (String)"thermalexpansion:icons/Icon_SlotSchematic", (IconRegister)event.map);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @ForgeSubscribe
    public void initializeIcons(TextureStitchEvent.Post event) {
        ProxyClient.setFluidIcons(TEFluids.fluidRedstone);
        ProxyClient.setFluidIcons(TEFluids.fluidGlowstone);
        ProxyClient.setFluidIcons(TEFluids.fluidEnder);
        ProxyClient.setFluidIcons(TEFluids.fluidPyrotheum);
        ProxyClient.setFluidIcons(TEFluids.fluidCryotheum);
        ProxyClient.setFluidIcons(TEFluids.fluidCoal);
        ProxyClient.setFluidIcons(TEFluids.fluidSteam);
        RenderDynamo.initialize();
        RenderEnergyCell.initialize();
        RenderTank.initialize();
        RenderStrongbox.initialize();
        RenderConduit.initialize();
        RenderTesseract.initialize();
        RenderPlate.initialize();
        RenderLamp.initialize();
        RenderEntityFlorb.initialize();
        RenderEntityBlizz.initialize();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @ForgeSubscribe
    public void initializeSounds(SoundLoadEvent event) {
        String[] files;
        String folder = "mob/blizz/";
        for (String sound : files = new String[]{"ambient", "breathe1", "breathe2", "breathe3", "spike1"}) {
            try {
                event.manager.func_77372_a(Utils.getSoundName(folder + sound, true));
                ThermalExpansion.log.fine("Loaded sound: " + sound);
            }
            catch (Exception e) {
                ThermalExpansion.log.log(Level.SEVERE, String.format("Unable to load sound: %s [[%s]]", folder + sound, e.toString()));
            }
        }
    }

    @Override
    public void updateTesseractGui() {
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiTesseract) {
            ((GuiTesseract)Minecraft.func_71410_x().field_71462_r).updateNames();
        }
    }

    public static void registerFluidIcons(Fluid fluid, IconRegister ir) {
        String name = StringHelper.titleCase((String)fluid.getName());
        IconRegistry.addIcon((String)("Fluid" + name), (String)("thermalexpansion:fluid/Fluid_" + name + "_Still"), (IconRegister)ir);
        IconRegistry.addIcon((String)("Fluid" + name + 1), (String)("thermalexpansion:fluid/Fluid_" + name + "_Flow"), (IconRegister)ir);
    }

    public static void setFluidIcons(Fluid fluid) {
        String name = StringHelper.titleCase((String)fluid.getName());
        fluid.setIcons(IconRegistry.getIcon((String)("Fluid" + name)), IconRegistry.getIcon((String)("Fluid" + name), (int)1));
    }
}

