/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.fluid;

import cofh.render.IconRegistry;
import cofh.util.StringHelper;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import thermalexpansion.render.particle.EntityDropParticleFX;

public abstract class BlockFluidTEBase
extends BlockFluidClassic {
    String name = "";
    protected float particleRed = 1.0f;
    protected float particleGreen = 1.0f;
    protected float particleBlue = 1.0f;

    public BlockFluidTEBase(int id, Fluid fluid, Material material, String name) {
        super(id, fluid, material);
        this.name = StringHelper.titleCase((String)name);
        this.setRenderPass(1);
        this.func_71864_b("thermalexpansion.fluid." + name);
        this.displacementIds.put(id, false);
    }

    public BlockFluidTEBase setParticleColor(float particleRed, float particleGreen, float particleBlue) {
        this.particleRed = particleRed;
        this.particleGreen = particleGreen;
        this.particleBlue = particleBlue;
        return this;
    }

    public void func_94332_a(IconRegister ir) {
        IconRegistry.addIcon((String)("Fluid" + this.name), (String)("thermalexpansion:fluid/Fluid_" + this.name + "_Still"), (IconRegister)ir);
        IconRegistry.addIcon((String)("Fluid" + this.name + "1"), (String)("thermalexpansion:fluid/Fluid_" + this.name + "_Flow"), (IconRegister)ir);
    }

    public Icon func_71858_a(int side, int meta) {
        return side <= 1 ? IconRegistry.getIcon((String)("Fluid" + this.name)) : IconRegistry.getIcon((String)("Fluid" + this.name), (int)1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_71862_a(World world, int x, int y, int z, Random rand) {
        super.func_71862_a(world, x, y, z, rand);
        double px = (float)x + rand.nextFloat();
        double py = (double)y - 1.05;
        double pz = (float)z + rand.nextFloat();
        if (this.density < 0) {
            py = (double)y + 2.1;
        }
        if (rand.nextInt(20) == 0 && world.isBlockSolidOnSide(x, y + this.densityDir, z, this.densityDir == -1 ? ForgeDirection.UP : ForgeDirection.DOWN) && !world.func_72803_f(x, y + 2 * this.densityDir, z).func_76230_c()) {
            EntityDropParticleFX fx = new EntityDropParticleFX(world, px, py, pz, this.particleRed, this.particleGreen, this.particleBlue, this.densityDir);
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    public boolean canDisplace(IBlockAccess world, int x, int y, int z) {
        if (world.func_72803_f(x, y, z).func_76224_d()) {
            return false;
        }
        return super.canDisplace(world, x, y, z);
    }

    public boolean displaceIfPossible(World world, int x, int y, int z) {
        if (world.func_72803_f(x, y, z).func_76224_d()) {
            return false;
        }
        return super.displaceIfPossible(world, x, y, z);
    }
}

