/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.gui.client.device;

import cofh.api.tileentity.ISecureTile;
import cofh.gui.GuiBase;
import cofh.gui.GuiBaseAdv;
import cofh.gui.element.ElementBase;
import cofh.gui.element.ElementButton;
import cofh.gui.element.TabBase;
import cofh.gui.element.TabInfo;
import cofh.gui.element.TabSecurity;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import thermalexpansion.block.device.TileWorkbench;
import thermalexpansion.gui.container.device.ContainerWorkbench;
import thermalexpansion.network.TEPacketHandler;

public class GuiWorkbench
extends GuiBaseAdv {
    static final String TEX_PATH = "thermalexpansion:textures/gui/device/Workbench.png";
    static final ResourceLocation TEXTURE = new ResourceLocation("thermalexpansion:textures/gui/device/Workbench.png");
    static final String INFO = "Crafts things!\n\nA crafting recipe may be written to or read from a schematic.\n\nStores its contents securely.";
    public TileWorkbench myTile;
    String playerName;
    ElementButton setSchematic;
    ElementButton getSchematic;

    public GuiWorkbench(InventoryPlayer inventory, TileEntity theTile) {
        super((Container)new ContainerWorkbench(inventory, theTile), TEXTURE);
        this.myTile = (TileWorkbench)theTile;
        this.name = this.myTile.func_70303_b();
        this.playerName = inventory.field_70458_d.field_71092_bJ;
        this.field_74195_c = 210;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.addTab((TabBase)new TabInfo((GuiBase)this, INFO));
        if (TileWorkbench.enableSecurity) {
            this.addTab((TabBase)new TabSecurity((GuiBase)this, (ISecureTile)this.myTile, this.playerName));
        }
        this.setSchematic = (ElementButton)this.addElement((ElementBase)new ElementButton((GuiBase)this, 98, 55, "Set", 176, 32, 176, 48, 176, 64, 16, 16, TEX_PATH));
        this.getSchematic = (ElementButton)this.addElement((ElementBase)new ElementButton((GuiBase)this, 98, 19, "Get", 192, 32, 192, 48, 192, 64, 16, 16, TEX_PATH));
    }

    protected void updateElements() {
        if (this.gridHasStuff()) {
            this.getSchematic.setToolTip("info.thermalexpansion.workbench.gridClear");
            this.getSchematic.setSheetX(208);
            this.getSchematic.setHoverX(208);
            this.getSchematic.setActive();
        } else if (this.hasValidSchematic()) {
            this.getSchematic.setToolTip("info.thermalexpansion.workbench.gridSet");
            this.getSchematic.setSheetX(192);
            this.getSchematic.setHoverX(192);
            this.getSchematic.setActive();
        } else {
            this.getSchematic.clearToolTip();
            this.getSchematic.setDisabled();
        }
        if (((ContainerWorkbench)this.field_74193_d).canWriteSchematic()) {
            this.setSchematic.setToolTip("info.thermalexpansion.workbench.writeSchematic");
            this.setSchematic.setActive();
        } else if (this.hasSchematic()) {
            this.setSchematic.setToolTip("info.thermalexpansion.workbench.noSchematic");
            this.setSchematic.setDisabled();
        } else {
            this.setSchematic.setToolTip("info.thermalexpansion.workbench.noRecipe");
            this.setSchematic.setDisabled();
        }
        this.myTile.createItemClient(false, ((ContainerWorkbench)this.field_74193_d).myOutput.getStackNoUpdate());
    }

    protected void func_74185_a(float f, int x, int y) {
        super.func_74185_a(f, x, y);
        this.field_73882_e.field_71446_o.func_110577_a(this.texture);
        this.drawCurSelection();
        this.drawCurMissing();
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (!this.myTile.canAccess) {
            this.field_73882_e.field_71439_g.func_71053_j();
        }
    }

    protected void drawCurMissing() {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (!this.myTile.missingItem[j + i * 3]) continue;
                this.func_73729_b(this.field_74198_m + 44 + j * 18, this.field_74197_n + 19 + i * 18, 176, 80, 16, 16);
            }
        }
    }

    protected void drawCurSelection() {
        int offset = 0;
        if (!this.hasSchematic()) {
            offset = 32;
        }
        switch (this.myTile.selectedSchematic) {
            case 0: {
                this.func_73729_b(this.field_74198_m + 15, this.field_74197_n + 15, 176 + offset, 0, 20, 20);
                break;
            }
            case 1: {
                this.func_73729_b(this.field_74198_m + 15, this.field_74197_n + 35, 176 + offset, 0, 20, 20);
                break;
            }
            case 2: {
                this.func_73729_b(this.field_74198_m + 15, this.field_74197_n + 55, 176 + offset, 0, 20, 20);
            }
        }
    }

    protected boolean gridHasStuff() {
        for (int i = 0; i < 9; ++i) {
            if (this.myTile.inventory[this.myTile.getMatrixOffset() + i] == null) continue;
            return true;
        }
        return false;
    }

    protected boolean hasSchematic() {
        return this.myTile.inventory[this.myTile.getCurrentSchematicSlot()] != null;
    }

    protected boolean hasValidSchematic() {
        return this.myTile.inventory[this.myTile.getCurrentSchematicSlot()] != null && this.myTile.inventory[this.myTile.getCurrentSchematicSlot()].field_77990_d != null;
    }

    public void handleElementButtonClick(String buttonName, int mouseButton) {
        if (buttonName.equals("Set")) {
            if (((ContainerWorkbench)this.field_74193_d).canWriteSchematic()) {
                TEPacketHandler.sendCreateSchematicPacketToServer();
                this.field_73882_e.field_71416_A.func_77366_a("random.click", 1.0f, 0.8f);
            }
        } else if (buttonName.equals("Get")) {
            if (this.gridHasStuff()) {
                this.myTile.clearCraftingGrid();
                this.field_73882_e.field_71416_A.func_77366_a("random.click", 1.0f, 0.6f);
            } else if (this.hasValidSchematic()) {
                this.myTile.setCraftingGrid();
                this.field_73882_e.field_71416_A.func_77366_a("random.click", 1.0f, 0.8f);
            }
        }
    }

    public void overlayRecipe() {
        if (!this.gridHasStuff()) {
            this.getSchematic.setToolTip("info.thermalexpansion.workbench.gridSet");
            this.getSchematic.setSheetX(192);
            this.getSchematic.setHoverX(192);
        } else {
            this.getSchematic.setToolTip("info.thermalexpansion.workbench.gridClear");
            this.getSchematic.setSheetX(208);
            this.getSchematic.setHoverX(208);
        }
    }
}

