/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.item.charm;

import cofh.api.energy.IEnergyContainerItem;
import cofh.util.EnergyHelper;
import net.minecraft.item.ItemStack;
import thermalexpansion.item.charm.ItemCharm;

public class ItemCharmRF
extends ItemCharm
implements IEnergyContainerItem {
    protected int maxEnergy = 16000;
    protected int maxTransfer = 80;

    public ItemCharmRF(int id) {
        super(id);
    }

    public ItemStack setDefaultTag(ItemStack container, int energy) {
        return EnergyHelper.setDefaultEnergyTag((ItemStack)container, (int)energy);
    }

    public int getDisplayDamage(ItemStack stack) {
        if (stack.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)stack, (int)0);
        }
        return 1 + this.maxEnergy - stack.field_77990_d.func_74762_e("Energy");
    }

    public int getMaxDamage(ItemStack stack) {
        return 1 + this.maxEnergy;
    }

    public boolean isDamaged(ItemStack stack) {
        return stack.func_77960_j() != Short.MAX_VALUE;
    }

    protected boolean hasEnergy(ItemStack container, int energy) {
        return this.getEnergyStored(container) >= energy;
    }

    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (container.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)container, (int)0);
        }
        int stored = container.field_77990_d.func_74762_e("Energy");
        int receive = Math.min(maxReceive, Math.min(this.maxEnergy - stored, this.maxTransfer));
        if (!simulate) {
            container.field_77990_d.func_74768_a("Energy", stored += receive);
        }
        return receive;
    }

    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (container.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)container, (int)0);
        }
        int stored = container.field_77990_d.func_74762_e("Energy");
        int extract = Math.min(maxExtract, stored);
        if (!simulate) {
            container.field_77990_d.func_74768_a("Energy", stored -= extract);
        }
        return extract;
    }

    public int getEnergyStored(ItemStack container) {
        if (container.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)container, (int)0);
        }
        return container.field_77990_d.func_74762_e("Energy");
    }

    public int getMaxEnergyStored(ItemStack container) {
        return this.maxEnergy;
    }
}

