/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.part.conduit.item;

import thermalexpansion.part.conduit.ConduitBase;
import thermalexpansion.part.conduit.Grid;
import thermalexpansion.part.conduit.GridTickHandler;
import thermalexpansion.part.conduit.item.ConduitItem;

public class GridItem
extends Grid {
    public GridItem(ConduitItem myNode) {
        super(myNode);
    }

    @Override
    public void addConduit(ConduitBase theCond) {
        super.addConduit(theCond);
        this.setRoutesInvalid();
    }

    @Override
    public void removeConduit(ConduitBase theCond) {
        this.nodeSet.remove(theCond);
        this.conduitSet.remove(theCond);
        if (theCond.isNode) {
            this.rebalanceGrid();
        }
        this.setRoutesInvalid();
        if (this.nodeSet.isEmpty() && this.conduitSet.isEmpty()) {
            GridTickHandler.tickingGridsToRemove.add(this);
        }
    }

    public void setRoutesInvalid() {
        for (ConduitBase curTile : this.conduitSet) {
            curTile.setRouteInvalid();
        }
        for (ConduitBase curTile : this.nodeSet) {
            curTile.setRouteInvalid();
        }
    }

    public void setUnvisited() {
        for (ConduitBase curTile : this.conduitSet) {
            curTile.setUnvisited();
        }
        for (ConduitBase curTile : this.nodeSet) {
            curTile.setUnvisited();
        }
    }

    @Override
    public void doGridUpdate() {
        if (this.nodeSet.isEmpty() && this.conduitSet.isEmpty()) {
            GridTickHandler.tickingGridsToRemove.add(this);
            return;
        }
        for (ConduitBase curCond : this.nodeSet) {
            curCond.doOutput();
        }
        for (ConduitBase curCond : this.conduitSet) {
            curCond.doOutput();
        }
    }

    @Override
    public void mergeGrid(Grid theGrid) {
        for (ConduitBase aConduit : theGrid.nodeSet) {
            aConduit.setGrid(this);
        }
        for (ConduitBase aConduit : theGrid.conduitSet) {
            aConduit.setGrid(this);
        }
        this.nodeSet.addAll(theGrid.nodeSet);
        this.conduitSet.addAll(theGrid.conduitSet);
        this.rebalanceGrid();
        this.setRoutesInvalid();
        GridTickHandler.tickingGridsToRemove.add(theGrid);
    }

    @Override
    public boolean isItemGrid() {
        return true;
    }
}

