/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.plugins.nei.handlers;

import codechicken.core.gui.GuiDraw;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import cofh.render.RenderHelper;
import cofh.util.ItemHelper;
import cofh.util.StringHelper;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.opengl.GL11;

public abstract class RecipeHandlerBase
extends TemplateRecipeHandler {
    Class containerClass;
    String recipeName;
    static final String TEXTURE = "thermalexpansion:textures/gui/NEIHandler.png";
    int[] trCoords = new int[4];
    int maxEnergy = 24000;
    int scaleEnergy = 42;
    int maxFluid = 10000;
    int scaleFluid = 60;
    int[] energyAmount = new int[2];
    int[] fluidAmount = new int[2];
    int[] lastCycle = new int[2];
    int[] arecipe = new int[]{-1, -1};

    public void loadTransferRects() {
        this.initialize();
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(this.trCoords[0], this.trCoords[1], this.trCoords[2], this.trCoords[3]), this.getOverlayIdentifier(), new Object[0]));
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return this.containerClass;
    }

    public String getRecipeName() {
        return StringHelper.localize((String)("info.thermalexpansion.neihandler." + this.recipeName));
    }

    public String getGuiTexture() {
        return TEXTURE;
    }

    public String getOverlayIdentifier() {
        return "thermalexpansion." + this.recipeName;
    }

    public abstract void initialize();

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)5, (int)11, (int)166, (int)65);
        this.drawBackgroundExtras(recipe);
    }

    public void drawBackgroundExtras(int recipe) {
    }

    public boolean keyTyped(GuiRecipe gui, char keyChar, int keyCode, int recipe) {
        if (keyCode == NEIClientConfig.getKeyBinding((String)"gui.recipe") ? this.transferFluidTank(gui, recipe, false) : keyCode == NEIClientConfig.getKeyBinding((String)"gui.usage") && this.transferFluidTank(gui, recipe, true)) {
            return true;
        }
        return super.keyTyped(gui, keyChar, keyCode, recipe);
    }

    public boolean mouseClicked(GuiRecipe gui, int button, int recipe) {
        if (button == 0 ? this.transferFluidTank(gui, recipe, false) : button == 1 && this.transferFluidTank(gui, recipe, true)) {
            return true;
        }
        return super.mouseClicked(gui, button, recipe);
    }

    protected boolean transferFluidTank(GuiRecipe gui, int recipe, boolean usage) {
        int minX1 = 153;
        int maxX1 = 169;
        int minY1 = 19;
        int maxY1 = 79;
        int yOffset = 65;
        Point mousepos = GuiDraw.getMousePosition();
        FluidStack fluid = null;
        if (mousepos.x >= minX1 + gui.field_74198_m && mousepos.x < maxX1 + gui.field_74198_m && mousepos.y >= minY1 + gui.field_74197_n && mousepos.y < maxY1 + gui.field_74197_n && this.arecipe[0] == recipe) {
            fluid = ((NEIRecipeBase)((Object)this.arecipes.get((int)recipe))).fluid;
        } else if (mousepos.x >= minX1 + gui.field_74198_m && mousepos.x < maxX1 + gui.field_74198_m && mousepos.y >= minY1 + gui.field_74197_n + yOffset && mousepos.y < maxY1 + gui.field_74197_n + yOffset && this.arecipe[1] == recipe) {
            fluid = ((NEIRecipeBase)((Object)this.arecipes.get((int)recipe))).fluid;
        }
        return fluid != null && fluid.amount > 0 && (usage ? GuiUsageRecipe.openRecipeGui((String)"liquid", (Object[])new Object[]{fluid}) : GuiCraftingRecipe.openRecipeGui((String)"liquid", (Object[])new Object[]{fluid}));
    }

    private void resetCounters() {
        this.arecipe[0] = -1;
        this.arecipe[1] = -1;
        this.energyAmount[0] = 0;
        this.energyAmount[1] = 0;
        this.fluidAmount[0] = 0;
        this.fluidAmount[1] = 0;
        this.lastCycle[0] = 0;
        this.lastCycle[1] = 0;
    }

    public void drawEnergy(int recipe) {
        int recipeIndex = 0;
        if (this.arecipe[0] == -1) {
            this.arecipe[0] = recipe;
        } else if (this.arecipe[1] == -1 && this.arecipe[0] != recipe) {
            this.arecipe[1] = recipe;
        }
        if (this.arecipe[0] != recipe && this.arecipe[1] != recipe) {
            this.resetCounters();
            this.drawEnergy(recipe);
            return;
        }
        if (this.arecipe[1] == recipe) {
            recipeIndex = 1;
        }
        GuiDraw.drawTexturedModalRect((int)4, (int)2, (int)0, (int)96, (int)16, (int)this.scaleEnergy);
        int energy = this.getScaledEnergy(this.energyAmount[recipeIndex]);
        GuiDraw.drawTexturedModalRect((int)4, (int)(2 + energy), (int)16, (int)(96 + energy), (int)16, (int)(this.scaleEnergy - energy));
        if (this.cycleticks % 20 == 0 && this.cycleticks != this.lastCycle[recipeIndex]) {
            if (this.energyAmount[recipeIndex] == this.maxEnergy) {
                this.energyAmount[recipeIndex] = 0;
            }
            int n = recipeIndex;
            this.energyAmount[n] = this.energyAmount[n] + ((NEIRecipeBase)((Object)this.arecipes.get((int)recipe))).energy;
            if (this.energyAmount[recipeIndex] > this.maxEnergy) {
                this.energyAmount[recipeIndex] = this.maxEnergy;
            }
            this.lastCycle[recipeIndex] = this.cycleticks;
        }
    }

    public void drawFluid(int recipe, boolean increase) {
        int recipeIndex = 0;
        if (this.arecipe[0] == -1) {
            this.arecipe[0] = recipe;
        } else if (this.arecipe[1] == -1 && this.arecipe[0] != recipe) {
            this.arecipe[1] = recipe;
        }
        if (this.arecipe[0] != recipe && this.arecipe[1] != recipe) {
            this.resetCounters();
            this.drawFluid(recipe, increase);
            return;
        }
        if (this.arecipe[1] == recipe) {
            recipeIndex = 1;
        }
        GuiDraw.drawTexturedModalRect((int)147, (int)2, (int)32, (int)96, (int)18, (int)(this.scaleFluid + 2));
        int fluid = this.getScaledFluid(this.fluidAmount[recipeIndex]);
        if (increase) {
            this.drawFluidRect(148, 3 + this.scaleFluid - fluid, ((NEIRecipeBase)((Object)this.arecipes.get((int)recipe))).fluid, 16, fluid);
        } else {
            this.drawFluidRect(148, 3 + fluid, ((NEIRecipeBase)((Object)this.arecipes.get((int)recipe))).fluid, 16, this.scaleFluid - fluid);
        }
        if (this.cycleticks % 20 == 0 && this.cycleticks != this.lastCycle[recipeIndex]) {
            if (this.fluidAmount[recipeIndex] == this.maxFluid) {
                this.fluidAmount[recipeIndex] = 0;
            }
            int n = recipeIndex;
            this.fluidAmount[n] = this.fluidAmount[n] + ((NEIRecipeBase)((Object)this.arecipes.get((int)recipe))).fluid.amount;
            if (this.fluidAmount[recipeIndex] > this.maxFluid) {
                this.fluidAmount[recipeIndex] = this.maxFluid;
            }
        }
        GuiDraw.drawTexturedModalRect((int)148, (int)2, (int)80, (int)96, (int)18, (int)(this.scaleFluid + 2));
    }

    public int getScaledEnergy(int amount) {
        return amount * this.scaleEnergy / this.maxEnergy;
    }

    public int getScaledFluid(int amount) {
        return amount * this.scaleFluid / this.maxFluid;
    }

    protected void drawFluidRect(int j, int k, FluidStack fluid, int width, int height) {
        if (height > this.scaleFluid) {
            height = this.scaleFluid;
        }
        int drawHeight = 0;
        int drawWidth = 0;
        RenderHelper.setBlockTextureSheet();
        RenderHelper.setColor3ub((int)fluid.getFluid().getColor(fluid));
        for (int x = 0; x < width; x += 16) {
            for (int y = 0; y < height; y += 16) {
                drawWidth = Math.min(width - x, 16);
                drawHeight = Math.min(height - y, 16);
                RecipeHandlerBase.drawScaledTexturedModelRectFromIcon(j + x, k + y, fluid.getFluid().getIcon(), drawWidth, drawHeight);
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
    }

    public static void drawScaledTexturedModelRectFromIcon(int i, int j, Icon icon, int x, int y) {
        if (icon == null) {
            return;
        }
        double minU = icon.func_94209_e();
        double maxU = icon.func_94212_f();
        double minV = icon.func_94206_g();
        double maxV = icon.func_94210_h();
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(i + 0), (double)(j + y), (double)GuiDraw.gui.getZLevel(), minU, minV + (maxV - minV) * (double)y / 16.0);
        tessellator.func_78374_a((double)(i + x), (double)(j + y), (double)GuiDraw.gui.getZLevel(), minU + (maxU - minU) * (double)x / 16.0, minV + (maxV - minV) * (double)y / 16.0);
        tessellator.func_78374_a((double)(i + x), (double)(j + 0), (double)GuiDraw.gui.getZLevel(), minU + (maxU - minU) * (double)x / 16.0, minV);
        tessellator.func_78374_a((double)(i + 0), (double)(j + 0), (double)GuiDraw.gui.getZLevel(), minU, minV);
        tessellator.func_78381_a();
    }

    abstract class NEIRecipeBase
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack input;
        PositionedStack secondaryInput;
        PositionedStack output;
        PositionedStack secondaryOutput;
        String inputOreName;
        ArrayList<ItemStack> inputList;
        String secondaryInputOreName;
        ArrayList<ItemStack> secondaryList;
        int inputOrePosition;
        int secondaryOrePosition;
        FluidStack fluid;
        int secondaryOutputChance;
        int energy;

        NEIRecipeBase() {
            super((TemplateRecipeHandler)RecipeHandlerBase.this);
            this.input = null;
            this.secondaryInput = null;
            this.output = null;
            this.secondaryOutput = null;
            this.inputOreName = "Unknown";
            this.inputList = null;
            this.secondaryInputOreName = "Unknown";
            this.secondaryList = null;
            this.inputOrePosition = 0;
            this.secondaryOrePosition = 0;
            this.fluid = null;
            this.secondaryOutputChance = 0;
            this.energy = 0;
        }

        protected void setOres() {
            if (this.input != null) {
                this.inputOreName = ItemHelper.getOreName((ItemStack)this.input.item);
                if (!this.inputOreName.equals("Unknown")) {
                    this.inputList = OreDictionary.getOres((String)this.inputOreName);
                }
            }
            if (this.secondaryInput != null) {
                this.secondaryInputOreName = ItemHelper.getOreName((ItemStack)this.secondaryInput.item);
                if (!this.secondaryInputOreName.equals("Unknown")) {
                    this.secondaryList = OreDictionary.getOres((String)this.secondaryInputOreName);
                }
            }
        }

        protected void incrementPrimary() {
            if (!this.inputOreName.equals("Unknown")) {
                ++this.inputOrePosition;
                this.inputOrePosition %= this.inputList.size();
                this.input.item.field_77993_c = this.inputList.get((int)this.inputOrePosition).field_77993_c;
                if (this.inputList.get(this.inputOrePosition).func_77960_j() != Short.MAX_VALUE) {
                    this.input.item.func_77964_b(this.inputList.get(this.inputOrePosition).func_77960_j());
                }
            }
        }

        protected void incrementSecondary() {
            if (!this.secondaryInputOreName.equals("Unknown")) {
                ++this.secondaryOrePosition;
                this.secondaryOrePosition %= this.secondaryList.size();
                this.secondaryInput.item.field_77993_c = this.secondaryList.get((int)this.secondaryOrePosition).field_77993_c;
                if (this.secondaryList.get(this.secondaryOrePosition).func_77960_j() != Short.MAX_VALUE) {
                    this.secondaryInput.item.func_77964_b(this.secondaryList.get(this.secondaryOrePosition).func_77960_j());
                }
            }
        }

        public PositionedStack getIngredient() {
            if (RecipeHandlerBase.this.cycleticks % 20 == 0) {
                this.incrementPrimary();
            }
            return this.input;
        }

        public PositionedStack getResult() {
            return this.output;
        }

        public ArrayList<PositionedStack> getOtherStacks() {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            if (this.secondaryOutput != null) {
                stacks.add(this.secondaryOutput);
            }
            if (this.secondaryInput != null) {
                if (RecipeHandlerBase.this.cycleticks % 20 == 0) {
                    this.incrementSecondary();
                }
                stacks.add(this.secondaryInput);
            }
            return stacks;
        }
    }
}

