/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.plugins.nei.handlers;

import codechicken.core.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import java.awt.Point;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import thermalexpansion.gui.client.machine.GuiTransposer;
import thermalexpansion.plugins.nei.handlers.RecipeHandlerBase;
import thermalexpansion.util.crafting.TransposerManager;

public class RecipeHandlerTransposer
extends RecipeHandlerBase {
    public static RecipeHandlerTransposer instance = new RecipeHandlerTransposer();

    public RecipeHandlerTransposer() {
        this.maxEnergy = 48000;
    }

    @Override
    public void initialize() {
        this.trCoords = new int[]{107, 8, 24, 18};
        this.recipeName = "transposer";
        this.containerClass = GuiTransposer.class;
    }

    @Override
    public void drawBackgroundExtras(int recipe) {
        GuiDraw.drawTexturedModalRect((int)74, (int)10, (int)176, (int)96, (int)18, (int)18);
        GuiDraw.drawTexturedModalRect((int)71, (int)37, (int)224, (int)96, (int)26, (int)26);
        GuiDraw.drawTexturedModalRect((int)36, (int)20, (int)224, (int)0, (int)16, (int)16);
        this.drawProgressBar(36, 20, 240, 0, 16, 16, 100, 7);
        if (((NEIRecipeTransposer)((Object)this.arecipes.get((int)recipe))).fillRecipe) {
            this.drawFluid(recipe, false);
            GuiDraw.drawTexturedModalRect((int)107, (int)9, (int)176, (int)32, (int)24, (int)16);
            int fluidSize = (int)((float)(this.cycleticks % 20) / 20.0f * 24.0f);
            this.drawFluidRect(131 - fluidSize, 9, ((RecipeHandlerBase.NEIRecipeBase)((Object)this.arecipes.get((int)recipe))).fluid, fluidSize, 16);
            this.drawProgressBar(107, 9, 200, 32, 24, 16, 20, 2);
        } else {
            this.drawFluid(recipe, true);
            GuiDraw.drawTexturedModalRect((int)107, (int)9, (int)176, (int)48, (int)24, (int)16);
            this.drawFluidRect(107, 9, ((RecipeHandlerBase.NEIRecipeBase)((Object)this.arecipes.get((int)recipe))).fluid, (int)((float)(this.cycleticks % 20) / 20.0f * 24.0f), 16);
            this.drawProgressBar(107, 9, 200, 48, 24, 16, 20, 0);
        }
    }

    public void drawExtras(int recipe) {
        this.drawEnergy(recipe);
        int energy = ((RecipeHandlerBase.NEIRecipeBase)((Object)this.arecipes.get((int)recipe))).energy;
        if (energy < 1000) {
            GuiDraw.drawString((String)(energy + "RF"), (int)36, (int)54, (int)0x939393, (boolean)false);
        } else if (energy < 10000) {
            GuiDraw.drawString((String)(energy + "RF"), (int)30, (int)54, (int)0x939393, (boolean)false);
        } else {
            GuiDraw.drawString((String)(energy + "RF"), (int)24, (int)54, (int)0x939393, (boolean)false);
        }
        int fluid = ((RecipeHandlerBase.NEIRecipeBase)((Object)this.arecipes.get((int)recipe))).fluid.amount;
        if (fluid < 100) {
            GuiDraw.drawString((String)(fluid + "mB"), (int)120, (int)54, (int)0x939393, (boolean)false);
        } else if (fluid < 1000) {
            GuiDraw.drawString((String)(fluid + "mB"), (int)114, (int)54, (int)0x939393, (boolean)false);
        } else if (fluid < 10000) {
            GuiDraw.drawString((String)(fluid + "mB"), (int)108, (int)54, (int)0x939393, (boolean)false);
        }
        int secondChance = ((RecipeHandlerBase.NEIRecipeBase)((Object)this.arecipes.get((int)recipe))).secondaryOutputChance;
        if (secondChance < 10) {
            GuiDraw.drawString((String)(secondChance + "%"), (int)120, (int)46, (int)0x939393, (boolean)false);
        } else if (secondChance < 100) {
            GuiDraw.drawString((String)(secondChance + "%"), (int)114, (int)46, (int)0x939393, (boolean)false);
        }
    }

    public List<String> handleTooltip(GuiRecipe gui, List<String> currenttip, int recipe) {
        int minX1 = 153;
        int maxX1 = 169;
        int minY1 = 19;
        int maxY1 = 79;
        int yOffset = 65;
        Point mousepos = GuiDraw.getMousePosition();
        if (mousepos.x >= minX1 + gui.field_74198_m && mousepos.x < maxX1 + gui.field_74198_m && mousepos.y >= minY1 + gui.field_74197_n && mousepos.y < maxY1 + gui.field_74197_n && this.arecipe[0] == recipe) {
            currenttip.add(((RecipeHandlerBase.NEIRecipeBase)((Object)this.arecipes.get((int)recipe))).fluid.getFluid().getLocalizedName());
        } else if (mousepos.x >= minX1 + gui.field_74198_m && mousepos.x < maxX1 + gui.field_74198_m && mousepos.y >= minY1 + gui.field_74197_n + yOffset && mousepos.y < maxY1 + gui.field_74197_n + yOffset && this.arecipe[1] == recipe) {
            currenttip.add(((RecipeHandlerBase.NEIRecipeBase)((Object)this.arecipes.get((int)recipe))).fluid.getFluid().getLocalizedName());
        }
        return super.handleTooltip(gui, currenttip, recipe);
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getOverlayIdentifier())) {
            TransposerManager.RecipeTransposer[] recipes;
            for (TransposerManager.RecipeTransposer recipe : recipes = TransposerManager.getFillRecipeList()) {
                this.arecipes.add(new NEIRecipeTransposer(recipe, true));
            }
            for (TransposerManager.RecipeTransposer recipe : recipes = TransposerManager.getExtractionRecipeList()) {
                this.arecipes.add(new NEIRecipeTransposer(recipe, false));
            }
        } else if (outputId.equals("liquid") && results.length == 1 && results[0] instanceof FluidStack) {
            TransposerManager.RecipeTransposer[] recipes;
            for (TransposerManager.RecipeTransposer recipe : recipes = TransposerManager.getExtractionRecipeList()) {
                if (!recipe.getFluid().isFluidEqual((FluidStack)results[0])) continue;
                this.arecipes.add(new NEIRecipeTransposer(recipe, false));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        TransposerManager.RecipeTransposer[] recipes;
        for (TransposerManager.RecipeTransposer recipe : recipes = TransposerManager.getFillRecipeList()) {
            if (!NEIServerUtils.areStacksSameType((ItemStack)recipe.getOutput(), (ItemStack)result)) continue;
            this.arecipes.add(new NEIRecipeTransposer(recipe, true));
        }
        for (TransposerManager.RecipeTransposer recipe : recipes = TransposerManager.getExtractionRecipeList()) {
            if (!NEIServerUtils.areStacksSameType((ItemStack)recipe.getOutput(), (ItemStack)result)) continue;
            this.arecipes.add(new NEIRecipeTransposer(recipe, false));
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("fuel") && ((Object)((Object)this)).getClass() == RecipeHandlerTransposer.class) {
            this.loadCraftingRecipes(this.getOverlayIdentifier(), new Object[0]);
        } else if (inputId.equals("liquid") && ingredients.length == 1 && ingredients[0] instanceof FluidStack) {
            TransposerManager.RecipeTransposer[] recipes;
            for (TransposerManager.RecipeTransposer recipe : recipes = TransposerManager.getFillRecipeList()) {
                if (!recipe.getFluid().isFluidEqual((FluidStack)ingredients[0])) continue;
                this.arecipes.add(new NEIRecipeTransposer(recipe, true));
            }
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        TransposerManager.RecipeTransposer[] recipes;
        for (TransposerManager.RecipeTransposer recipe : recipes = TransposerManager.getFillRecipeList()) {
            if (!NEIServerUtils.areStacksSameType((ItemStack)recipe.getInput(), (ItemStack)ingredient)) continue;
            this.arecipes.add(new NEIRecipeTransposer(recipe, true));
        }
        for (TransposerManager.RecipeTransposer recipe : recipes = TransposerManager.getExtractionRecipeList()) {
            if (!NEIServerUtils.areStacksSameType((ItemStack)recipe.getInput(), (ItemStack)ingredient)) continue;
            this.arecipes.add(new NEIRecipeTransposer(recipe, false));
        }
    }

    class NEIRecipeTransposer
    extends RecipeHandlerBase.NEIRecipeBase {
        boolean fillRecipe = false;

        public NEIRecipeTransposer(TransposerManager.RecipeTransposer recipe, boolean fillRecipe) {
            this.input = new PositionedStack((Object)recipe.getInput(), 75, 11);
            if (recipe.getOutput() != null) {
                this.output = new PositionedStack((Object)recipe.getOutput(), 75, 41);
            }
            this.energy = recipe.getEnergy();
            this.fluid = recipe.getFluid();
            this.secondaryOutputChance = recipe.getChance();
            this.fillRecipe = fillRecipe;
            this.setOres();
        }
    }
}

