/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.launch;

import argo.jdom.JdomParser;
import argo.jdom.JsonNode;
import argo.jdom.JsonRootNode;
import argo.jdom.JsonStringNode;
import argo.saj.InvalidSyntaxException;
import cpw.mods.fml.common.versioning.ComparableVersion;
import cpw.mods.fml.relauncher.FMLInjectionData;
import cpw.mods.fml.relauncher.FMLLaunchHandler;
import cpw.mods.fml.relauncher.IFMLCallHook;
import cpw.mods.fml.relauncher.IFMLLoadingPlugin;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.Box;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import net.minecraft.launchwrapper.LaunchClassLoader;

public class DepLoader
implements IFMLLoadingPlugin,
IFMLCallHook {
    private static ByteBuffer downloadBuffer = ByteBuffer.allocateDirect(0x800000);
    private static final String owner = "CoFH DepLoader";
    private static DepLoadInst inst;

    public static void load() {
        if (inst == null) {
            inst = new DepLoadInst();
            inst.load();
        }
    }

    private static String[] splitFileName(String string) {
        Pattern pattern = Pattern.compile("(.+?)([\\d\\.\\w]+)(\\.[^\\d]+)");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.matches()) {
            return null;
        }
        return new String[]{matcher.group(1), matcher.group(2), matcher.group(3)};
    }

    public String[] getASMTransformerClass() {
        return null;
    }

    public String getModContainerClass() {
        return null;
    }

    public String getSetupClass() {
        return this.getClass().getName();
    }

    public void injectData(Map<String, Object> map) {
    }

    public Void call() {
        DepLoader.load();
        return null;
    }

    public String[] getLibraryRequestClass() {
        return null;
    }

    public static class DepLoadInst {
        private File modsDir;
        private File v_modsDir;
        private IDownloadDisplay downloadMonitor;
        private JDialog popupWindow;
        private Map<String, Dependancy> depMap = new HashMap<String, Dependancy>();
        private HashSet<String> depSet = new HashSet();

        public DepLoadInst() {
            String string = (String)FMLInjectionData.data()[4];
            File file = (File)FMLInjectionData.data()[6];
            this.modsDir = new File(file, "mods");
            this.v_modsDir = new File(file, "mods/" + string);
            if (!this.v_modsDir.exists()) {
                this.v_modsDir.mkdirs();
            }
        }

        private void addClasspath(String string) {
            try {
                ((LaunchClassLoader)DepLoader.class.getClassLoader()).addURL(new File(this.v_modsDir, string).toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                throw new RuntimeException(malformedURLException);
            }
        }

        private void download(Dependancy dependancy) {
            this.popupWindow = (JDialog)this.downloadMonitor.makeDialog();
            File file = new File(this.v_modsDir, dependancy.fileName());
            try {
                URL uRL = new URL(dependancy.url + '/' + dependancy.fileName());
                this.downloadMonitor.updateProgressString("Downloading file %s", uRL.toString());
                System.out.format("Downloading file %s\n", uRL.toString());
                URLConnection uRLConnection = uRL.openConnection();
                uRLConnection.setConnectTimeout(5000);
                uRLConnection.setReadTimeout(5000);
                uRLConnection.setRequestProperty("User-Agent", "CoFH DepLoader Downloader");
                int n = uRLConnection.getContentLength();
                this.download(uRLConnection.getInputStream(), n, file);
                this.downloadMonitor.updateProgressString("Download complete", new Object[0]);
                System.out.println("Download complete");
                this.scanDepInfo(file);
            }
            catch (Exception exception) {
                file.delete();
                if (this.downloadMonitor.shouldStopIt()) {
                    System.err.println("You have stopped the downloading operation before it could complete");
                    System.exit(1);
                    return;
                }
                this.downloadMonitor.showErrorDialog(dependancy.fileName(), dependancy.url + '/' + dependancy.fileName());
                throw new RuntimeException("A download error occured", exception);
            }
        }

        private void download(InputStream inputStream, int n, File file) throws Exception {
            Object object;
            if (n > downloadBuffer.capacity()) {
                throw new Exception(String.format("The file %s is too large to be downloaded by CoFH DepLoader - the download is invalid", file.getName()));
            }
            downloadBuffer.clear();
            int n2 = 0;
            this.downloadMonitor.resetProgress(n);
            try {
                int n3;
                this.downloadMonitor.setPokeThread(Thread.currentThread());
                object = new byte[1024];
                while ((n3 = inputStream.read((byte[])object)) >= 0) {
                    downloadBuffer.put((byte[])object, 0, n3);
                    n2 += n3;
                    if (this.downloadMonitor.shouldStopIt()) break;
                    this.downloadMonitor.updateProgress(n2);
                }
                inputStream.close();
                this.downloadMonitor.setPokeThread(null);
                downloadBuffer.limit(n2);
                downloadBuffer.position(0);
            }
            catch (InterruptedIOException interruptedIOException) {
                Thread.interrupted();
                throw new Exception("Stop");
            }
            catch (IOException iOException) {
                throw iOException;
            }
            if (!file.exists()) {
                file.createNewFile();
            }
            downloadBuffer.position(0);
            object = new FileOutputStream(file);
            ((FileOutputStream)object).getChannel().write(downloadBuffer);
            ((FileOutputStream)object).close();
        }

        private String checkExisting(String[] stringArray) {
            String[] stringArray2;
            for (File file : this.modsDir.listFiles()) {
                stringArray2 = DepLoader.splitFileName(file.getName());
                if (stringArray2 == null || !stringArray2[0].equals(stringArray[0]) || file.renameTo(new File(this.v_modsDir, file.getName())) || file.delete()) continue;
                file.deleteOnExit();
            }
            for (File file : this.v_modsDir.listFiles()) {
                stringArray2 = DepLoader.splitFileName(file.getName());
                if (stringArray2 == null || !stringArray2[0].equals(stringArray[0])) continue;
                ComparableVersion comparableVersion = new ComparableVersion(stringArray2[1]);
                ComparableVersion comparableVersion2 = new ComparableVersion(stringArray[1]);
                int n = comparableVersion.compareTo(comparableVersion2);
                if (n < 0) {
                    System.out.println("Deleted old version " + file.getName());
                    file.delete();
                    return null;
                }
                if (n > 0) {
                    System.err.println("Warning: version of " + stringArray[0] + ", " + stringArray2[1] + " is newer than request " + stringArray[1]);
                    return file.getName();
                }
                return file.getName();
            }
            return null;
        }

        public void load() {
            this.scanDepInfos();
            if (this.depMap.isEmpty()) {
                return;
            }
            this.loadDeps();
            this.activateDeps();
        }

        private void activateDeps() {
            for (Dependancy dependancy : this.depMap.values()) {
                if (!dependancy.coreLib) continue;
                this.addClasspath(dependancy.existing);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadDeps() {
            this.downloadMonitor = FMLLaunchHandler.side().isClient() ? new Downloader() : new DummyDownloader();
            try {
                while (!this.depSet.isEmpty()) {
                    Iterator<String> iterator = this.depSet.iterator();
                    Dependancy dependancy = this.depMap.get(iterator.next());
                    iterator.remove();
                    this.load(dependancy);
                }
            }
            finally {
                if (this.popupWindow != null) {
                    this.popupWindow.setVisible(false);
                    this.popupWindow.dispose();
                }
            }
        }

        private void load(Dependancy dependancy) {
            dependancy.existing = this.checkExisting(dependancy.filesplit);
            if (dependancy.existing == null) {
                this.download(dependancy);
                dependancy.existing = dependancy.fileName();
            }
        }

        private List<File> modFiles() {
            LinkedList<File> linkedList = new LinkedList<File>();
            linkedList.addAll(Arrays.asList(this.modsDir.listFiles()));
            linkedList.addAll(Arrays.asList(this.v_modsDir.listFiles()));
            return linkedList;
        }

        private void scanDepInfos() {
            for (File file : this.modFiles()) {
                if (!file.getName().endsWith(".jar") && !file.getName().endsWith(".zip")) continue;
                this.scanDepInfo(file);
            }
        }

        private void scanDepInfo(File file) {
            try {
                ZipFile zipFile = new ZipFile(file);
                ZipEntry zipEntry = zipFile.getEntry("dependancies.info");
                if (zipEntry != null) {
                    this.loadJSon(zipFile.getInputStream(zipEntry));
                }
                zipFile.close();
            }
            catch (Exception exception) {
                System.err.println("Failed to load dependancies.info from " + file.getName() + " as JSON");
                exception.printStackTrace();
            }
        }

        private void loadJSon(InputStream inputStream) throws IOException, InvalidSyntaxException {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            JsonRootNode jsonRootNode = new JdomParser().parse((Reader)inputStreamReader);
            if (jsonRootNode.hasElements()) {
                this.loadJSonArr(jsonRootNode);
            } else {
                this.loadJson((JsonNode)jsonRootNode);
            }
            inputStreamReader.close();
        }

        private void loadJSonArr(JsonRootNode jsonRootNode) throws IOException {
            for (JsonNode jsonNode : jsonRootNode.getElements()) {
                this.loadJson(jsonNode);
            }
        }

        private void loadJson(JsonNode jsonNode) throws IOException {
            boolean bl = ((LaunchClassLoader)DepLoader.class.getClassLoader()).getClassBytes("net.minecraft.world.World") == null;
            String string = jsonNode.getStringValue(new Object[]{"class"});
            if (DepLoader.class.getResource("/" + string.replace('.', '/') + ".class") != null) {
                return;
            }
            String string2 = jsonNode.getStringValue(new Object[]{"repo"});
            String string3 = jsonNode.getStringValue(new Object[]{"file"});
            if (!bl && jsonNode.isNode(new Object[]{"dev"})) {
                string3 = jsonNode.getStringValue(new Object[]{"dev"});
            }
            boolean bl2 = jsonNode.isNode(new Object[]{"coreLib"}) && jsonNode.getBooleanValue(new Object[]{"coreLib"}) != false;
            List<String> list = Arrays.asList("repo", "file", "class", "dev", "coreLib");
            for (Map.Entry entry : jsonNode.getFields().entrySet()) {
                String string4 = ((JsonStringNode)entry.getKey()).getText();
                if (!((JsonNode)entry.getValue()).hasText() || list.contains(string4)) continue;
                string3 = string3.replaceAll("@" + string4.toUpperCase() + "@", ((JsonNode)entry.getValue()).getText());
            }
            String[] stringArray = DepLoader.splitFileName(string3);
            if (stringArray == null) {
                throw new RuntimeException("Invalid filename format for dependancy: " + string3);
            }
            this.addDep(new Dependancy(string2, stringArray, bl2));
        }

        private void addDep(Dependancy dependancy) {
            if (this.mergeNew(this.depMap.get(dependancy.getName()), dependancy)) {
                this.depMap.put(dependancy.getName(), dependancy);
                this.depSet.add(dependancy.getName());
            }
        }

        private boolean mergeNew(Dependancy dependancy, Dependancy dependancy2) {
            if (dependancy == null) {
                return true;
            }
            Dependancy dependancy3 = dependancy2.version.compareTo(dependancy.version) > 0 ? dependancy2 : dependancy;
            dependancy3.coreLib = dependancy2.coreLib || dependancy.coreLib;
            return dependancy3 == dependancy2;
        }
    }

    public static class Dependancy {
        public String url;
        public String[] filesplit;
        public ComparableVersion version;
        public String existing;
        public boolean coreLib;

        public Dependancy(String string, String[] stringArray, boolean bl) {
            this.url = string;
            this.filesplit = stringArray;
            this.coreLib = bl;
            this.version = new ComparableVersion(stringArray[1]);
        }

        public String getName() {
            return this.filesplit[0];
        }

        public String fileName() {
            return this.filesplit[0] + this.filesplit[1] + this.filesplit[2];
        }
    }

    public static class DummyDownloader
    implements IDownloadDisplay {
        @Override
        public void resetProgress(int n) {
        }

        @Override
        public void setPokeThread(Thread thread) {
        }

        @Override
        public void updateProgress(int n) {
        }

        @Override
        public boolean shouldStopIt() {
            return false;
        }

        @Override
        public void updateProgressString(String string, Object ... objectArray) {
        }

        @Override
        public Object makeDialog() {
            return null;
        }

        @Override
        public void showErrorDialog(String string, String string2) {
        }
    }

    public static class Downloader
    extends JOptionPane
    implements IDownloadDisplay {
        private JDialog container;
        private JLabel currentActivity;
        private JProgressBar progress;
        boolean stopIt;
        Thread pokeThread;

        private Box makeProgressPanel() {
            Box box = Box.createVerticalBox();
            box.add(Box.createRigidArea(new Dimension(0, 10)));
            JLabel jLabel = new JLabel("<html><b><font size='+1'>CoFH DepLoader is setting up your minecraft environment</font></b></html>");
            box.add(jLabel);
            jLabel.setAlignmentY(0.0f);
            jLabel = new JLabel("<html>Please wait, CoFH DepLoader has some tasks to do before you can play</html>");
            jLabel.setAlignmentY(0.0f);
            box.add(jLabel);
            box.add(Box.createRigidArea(new Dimension(0, 10)));
            this.currentActivity = new JLabel("Currently doing ...");
            box.add(this.currentActivity);
            box.add(Box.createRigidArea(new Dimension(0, 10)));
            this.progress = new JProgressBar(0, 100);
            this.progress.setStringPainted(true);
            box.add(this.progress);
            box.add(Box.createRigidArea(new Dimension(0, 30)));
            return box;
        }

        @Override
        public JDialog makeDialog() {
            if (this.container != null) {
                return this.container;
            }
            this.setMessageType(1);
            this.setMessage(this.makeProgressPanel());
            this.setOptions(new Object[]{"Stop"});
            this.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getSource() == Downloader.this && propertyChangeEvent.getPropertyName() == "value") {
                        Downloader.this.requestClose("This will stop minecraft from launching\nAre you sure you want to do this?");
                    }
                }
            });
            this.container = new JDialog(null, "Hello", Dialog.ModalityType.MODELESS);
            this.container.setResizable(false);
            this.container.setLocationRelativeTo(null);
            this.container.add(this);
            this.updateUI();
            this.container.pack();
            this.container.setMinimumSize(this.container.getPreferredSize());
            this.container.setVisible(true);
            this.container.setDefaultCloseOperation(0);
            this.container.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    Downloader.this.requestClose("Closing this window will stop minecraft from launching\nAre you sure you wish to do this?");
                }
            });
            return this.container;
        }

        protected void requestClose(String string) {
            int n = JOptionPane.showConfirmDialog(this.container, string, "Are you sure you want to stop?", 0, 2);
            if (n == 0) {
                this.container.dispose();
            }
            this.stopIt = true;
            if (this.pokeThread != null) {
                this.pokeThread.interrupt();
            }
        }

        @Override
        public void updateProgressString(String string, Object ... objectArray) {
            if (this.currentActivity != null) {
                this.currentActivity.setText(String.format(string, objectArray));
            }
        }

        @Override
        public void resetProgress(int n) {
            if (this.progress != null) {
                this.progress.getModel().setRangeProperties(0, 0, 0, n, false);
            }
        }

        @Override
        public void updateProgress(int n) {
            if (this.progress != null) {
                this.progress.getModel().setValue(n);
            }
        }

        @Override
        public void setPokeThread(Thread thread) {
            this.pokeThread = thread;
        }

        @Override
        public boolean shouldStopIt() {
            return this.stopIt;
        }

        @Override
        public void showErrorDialog(String string, String string2) {
            JEditorPane jEditorPane = new JEditorPane("text/html", "<html>CoFH DepLoader was unable to download required library " + string + "<br>Check your internet connection and try restarting or download it manually from" + "<br><a href=\"" + string2 + "\">" + string2 + "</a> and put it in your mods folder" + "</html>");
            jEditorPane.setEditable(false);
            jEditorPane.setOpaque(false);
            jEditorPane.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                    try {
                        if (hyperlinkEvent.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                            Desktop.getDesktop().browse(hyperlinkEvent.getURL().toURI());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            JOptionPane.showMessageDialog(null, jEditorPane, "A download error has occured", 0);
        }
    }

    public static interface IDownloadDisplay {
        public void resetProgress(int var1);

        public void setPokeThread(Thread var1);

        public void updateProgress(int var1);

        public boolean shouldStopIt();

        public void updateProgressString(String var1, Object ... var2);

        public Object makeDialog();

        public void showErrorDialog(String var1, String var2);
    }
}

