/*
 * Decompiled with CFR 0.152.
 */
package denoflionsx.minefactoryreloaded.modhelpers.forestry;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.network.NetworkMod;
import denoflionsx.minefactoryreloaded.modhelpers.forestry.fertilizer.FertilizerForestry;
import denoflionsx.minefactoryreloaded.modhelpers.forestry.leaves.FertilizableForestryLeaves;
import denoflionsx.minefactoryreloaded.modhelpers.forestry.leaves.FruitForestry;
import denoflionsx.minefactoryreloaded.modhelpers.forestry.leaves.HarvestableLeaves;
import denoflionsx.minefactoryreloaded.modhelpers.forestry.peat.FertilizablePeat;
import denoflionsx.minefactoryreloaded.modhelpers.forestry.peat.HarvestablePeat;
import denoflionsx.minefactoryreloaded.modhelpers.forestry.peat.PlantablePeat;
import denoflionsx.minefactoryreloaded.modhelpers.forestry.pods.FertilizableForestryPods;
import denoflionsx.minefactoryreloaded.modhelpers.forestry.pods.FruitForestryPod;
import denoflionsx.minefactoryreloaded.modhelpers.forestry.trees.FertilizableForestryTree;
import denoflionsx.minefactoryreloaded.modhelpers.forestry.trees.HarvestableForestryTree;
import denoflionsx.minefactoryreloaded.modhelpers.forestry.trees.PlantableForestryTree;
import denoflionsx.minefactoryreloaded.modhelpers.forestry.utils.ForestryUtils;
import java.lang.reflect.Field;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import powercrystals.minefactoryreloaded.api.FactoryRegistry;

@Mod(modid="MFR Compat Forestry Trees", name="MFR Compat Forestry Trees", version="1.0", dependencies="after:Forestry")
@NetworkMod(clientSideRequired=false, serverSideRequired=false)
public class ForestryTrees {
    public static final String name = "MFR Compat Forestry Trees";
    public static ItemStack bog;

    @Mod.EventHandler
    public void init(FMLInitializationEvent fMLInitializationEvent) {
        if (Loader.isModLoaded((String)"Forestry")) {
            try {
                ForestryUtils.setTreeRoot();
                FactoryRegistry.registerPlantable(new PlantableForestryTree());
                FactoryRegistry.registerFertilizable(new FertilizableForestryTree());
                for (Field field : Class.forName("forestry.core.config.ForestryBlock").getDeclaredFields()) {
                    Block block;
                    if (field.getName().contains("log")) {
                        block = (Block)field.get(null);
                        if (block == null) continue;
                        FMLInterModComms.sendMessage((String)name, (String)"register_log", (ItemStack)new ItemStack(block));
                        continue;
                    }
                    if (field.getName().contains("leaves")) {
                        block = (Block)field.get(null);
                        if (block == null) continue;
                        FactoryRegistry.registerHarvestable(new HarvestableLeaves(block.field_71990_ca));
                        FactoryRegistry.registerFruit(new FruitForestry(block.field_71990_ca));
                        FactoryRegistry.registerFertilizable(new FertilizableForestryLeaves(block.field_71990_ca));
                        continue;
                    }
                    if (field.getName().contains("pods")) {
                        block = (Block)field.get(null);
                        if (block == null) continue;
                        FactoryRegistry.registerFruit(new FruitForestryPod(block.field_71990_ca));
                        FactoryRegistry.registerFertilizable(new FertilizableForestryPods(block.field_71990_ca));
                        continue;
                    }
                    if (!field.getName().equals("soil") || (block = (Block)field.get(null)) == null) continue;
                    bog = new ItemStack(block, 1, 1);
                    FactoryRegistry.registerPlantable(new PlantablePeat());
                    FactoryRegistry.registerHarvestable(new HarvestablePeat());
                    FactoryRegistry.registerFertilizable(new FertilizablePeat());
                }
                FactoryRegistry.registerFertilizer(new FertilizerForestry(ForestryUtils.getItem("fertilizerCompound")));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Mod.EventHandler
    public void IMCCallback(FMLInterModComms.IMCEvent iMCEvent) {
        for (FMLInterModComms.IMCMessage iMCMessage : iMCEvent.getMessages()) {
            if (!iMCMessage.key.equals("register_log")) continue;
            System.out.println("Processing IMC request register_log from " + iMCMessage.getSender());
            FactoryRegistry.registerHarvestable(new HarvestableForestryTree(iMCMessage.getItemStackValue().field_77993_c));
            FactoryRegistry.registerFruitLogBlockId(iMCMessage.getItemStackValue().field_77993_c);
        }
    }
}

