/*
 * Decompiled with CFR 0.152.
 */
package denoflionsx.minefactoryreloaded.modhelpers.forestry.leaves;

import denoflionsx.minefactoryreloaded.modhelpers.forestry.trees.PlantableForestryTree;
import denoflionsx.minefactoryreloaded.modhelpers.forestry.utils.ForestryUtils;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.ITree;
import forestry.api.genetics.IIndividual;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import powercrystals.minefactoryreloaded.api.HarvestType;
import powercrystals.minefactoryreloaded.api.IFactoryHarvestable;

public class HarvestableLeaves
implements IFactoryHarvestable {
    private int id;
    private Method m;
    public static final String settingKey = "playSounds";

    public HarvestableLeaves(int n) {
        this.id = n;
        try {
            this.m = Class.forName("forestry.arboriculture.gadgets.TileLeaves").getMethod("getRipeningTime", new Class[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public int getPlantId() {
        return this.id;
    }

    @Override
    public HarvestType getHarvestType() {
        return HarvestType.TreeLeaf;
    }

    @Override
    public boolean breakBlock() {
        return false;
    }

    @Override
    public boolean canBeHarvested(World world, Map<String, Boolean> map, int n, int n2, int n3) {
        return true;
    }

    @Override
    public List<ItemStack> getDrops(World world, Random random, Map<String, Boolean> map, int n, int n2, int n3) {
        ITree[] iTreeArray;
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
        TileEntity tileEntity = world.func_72796_p(n, n2, n3);
        if (tileEntity == null) {
            return arrayList;
        }
        if (PlantableForestryTree.getTree(tileEntity) == null) {
            return arrayList;
        }
        float f = 1.0f;
        if (map.get("silkTouch") != null && map.get("silkTouch").booleanValue()) {
            f = 100.0f;
        }
        for (ITree iTree : iTreeArray = PlantableForestryTree.getTree(tileEntity).getSaplings(world, n, n2, n3, f)) {
            if (iTree == null) continue;
            arrayList.add(ForestryUtils.root.getMemberStack((IIndividual)iTree, EnumGermlingType.SAPLING.ordinal()));
        }
        if (ForestryUtils.getFruitBearer(tileEntity).hasFruit()) {
            for (ITree iTree : PlantableForestryTree.getTree(tileEntity).produceStacks(world, n, n2, n3, this.getRipeTime(world, n, n2, n3))) {
                arrayList.add((ItemStack)iTree);
            }
        }
        if (map.get(settingKey).booleanValue()) {
            world.func_72889_a(null, 2001, n, n2, n3, world.func_72798_a(n, n2, n3) + (world.func_72805_g(n, n2, n3) << 12));
        }
        return arrayList;
    }

    private int getRipeTime(World world, int n, int n2, int n3) {
        try {
            return (Integer)this.m.invoke((Object)world.func_72796_p(n, n2, n3), new Object[0]);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0;
        }
    }

    @Override
    public void preHarvest(World world, int n, int n2, int n3) {
    }

    @Override
    public void postHarvest(World world, int n, int n2, int n3) {
        world.func_72932_q(n, n2, n3);
        world.func_94571_i(n, n2, n3);
    }
}

