/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import powercrystals.core.position.BlockPosition;
import powercrystals.minefactoryreloaded.MineFactoryReloadedCore;
import powercrystals.minefactoryreloaded.api.rednet.IRedNetDecorative;

public class BlockVineScaffold
extends Block
implements IRedNetDecorative {
    private Icon _sideIcon;
    private Icon _topIcon;
    private static final ForgeDirection[] _attachDirections = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.EAST, ForgeDirection.WEST};
    private static final int _attachDistance = 16;

    public BlockVineScaffold(int n) {
        super(n, Material.field_76257_i);
        this.func_71864_b("mfr.vinescaffold");
        this.func_71884_a(field_71965_g);
        this.func_71848_c(0.1f);
        this.func_71905_a(0.0f, 0.020833334f, 0.0f, 1.0f, 0.9791667f, 1.0f);
        this.func_71907_b(true);
    }

    public void func_71869_a(World world, int n, int n2, int n3, Entity entity) {
        if (entity instanceof EntityPlayerMP) {
            ((EntityPlayerMP)entity).field_71135_a.field_72572_g = 0;
        }
        entity.field_70143_R = 0.0f;
        if (entity.field_70123_F) {
            entity.field_70181_x = 0.2;
        } else if (entity.func_70093_af()) {
            double d = entity.field_70167_r - entity.field_70163_u;
            entity.field_70121_D.field_72338_b += d;
            entity.field_70121_D.field_72337_e += d;
            entity.field_70163_u = entity.field_70167_r;
        } else {
            entity.field_70181_x = -0.1;
        }
    }

    public AxisAlignedBB func_71872_e(World world, int n, int n2, int n3) {
        float f = 0.125f;
        return AxisAlignedBB.func_72330_a((double)((double)n + this.field_72026_ch + (double)f), (double)((double)n2 + this.field_72023_ci), (double)((double)n3 + this.field_72024_cj + (double)f), (double)((double)n + this.field_72021_ck - (double)f), (double)((double)n2 + this.field_72022_cl), (double)((double)n3 + this.field_72019_cm - (double)f));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconRegister) {
        this._sideIcon = iconRegister.func_94245_a("minefactoryreloaded:" + this.func_71917_a() + ".side");
        this._topIcon = iconRegister.func_94245_a("minefactoryreloaded:" + this.func_71917_a() + ".top");
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int n, int n2) {
        return n < 2 ? this._topIcon : this._sideIcon;
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean func_71886_c() {
        return false;
    }

    public int func_71857_b() {
        return MineFactoryReloadedCore.renderIdVineScaffold;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_71877_c(IBlockAccess iBlockAccess, int n, int n2, int n3, int n4) {
        return !iBlockAccess.func_72804_r(n, n2, n3);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_71889_f_(int n) {
        return ColorizerFoliage.func_77468_c();
    }

    @SideOnly(value=Side.CLIENT)
    public int func_71920_b(IBlockAccess iBlockAccess, int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                int n7 = iBlockAccess.func_72807_a(n + j, n3 + i).func_76726_l();
                n4 += (n7 & 0xFF0000) >> 16;
                n5 += (n7 & 0xFF00) >> 8;
                n6 += n7 & 0xFF;
            }
        }
        return (n4 / 9 & 0xFF) << 16 | (n5 / 9 & 0xFF) << 8 | n6 / 9 & 0xFF;
    }

    public boolean func_71903_a(World world, int n, int n2, int n3, EntityPlayer entityPlayer, int n4, float f, float f2, float f3) {
        if (entityPlayer.field_71071_by.field_70462_a[entityPlayer.field_71071_by.field_70461_c] != null && entityPlayer.field_71071_by.field_70462_a[entityPlayer.field_71071_by.field_70461_c].field_77993_c == this.field_71990_ca) {
            int n5 = world.func_72940_L();
            for (int i = n2 + 1; i < n5; ++i) {
                int n6 = world.func_72798_a(n, i, n3);
                Block block = Block.field_71973_m[n6];
                if (block == null || world.func_72799_c(n, i, n3) || block.isBlockReplaceable(world, n, i, n3)) {
                    if (!world.field_72995_K && world.func_72832_d(n, i, n3, this.field_71990_ca, 0, 3)) {
                        world.func_72889_a(null, 2001, n, i, n3, this.field_71990_ca);
                        if (!entityPlayer.field_71075_bZ.field_75098_d) {
                            --entityPlayer.field_71071_by.field_70462_a[entityPlayer.field_71071_by.field_70461_c].field_77994_a;
                            if (entityPlayer.field_71071_by.field_70462_a[entityPlayer.field_71071_by.field_70461_c].field_77994_a == 0) {
                                entityPlayer.field_71071_by.field_70462_a[entityPlayer.field_71071_by.field_70461_c] = null;
                            }
                        }
                    }
                    return true;
                }
                if (n6 == this.field_71990_ca) continue;
                return false;
            }
        }
        return false;
    }

    public boolean func_71930_b(World world, int n, int n2, int n3) {
        return this.func_71854_d(world, n, n2, n3);
    }

    public boolean func_71854_d(World world, int n, int n2, int n3) {
        if (world.isBlockSolidOnSide(n, n2 - 1, n3, ForgeDirection.UP)) {
            return true;
        }
        for (ForgeDirection forgeDirection : _attachDirections) {
            BlockPosition blockPosition = new BlockPosition(n, n2, n3, forgeDirection);
            for (int i = 0; i < 16; ++i) {
                blockPosition.moveForwards(1);
                if (world.func_72798_a(blockPosition.x, blockPosition.y, blockPosition.z) != this.field_71990_ca || !world.isBlockSolidOnSide(blockPosition.x, blockPosition.y - 1, blockPosition.z, ForgeDirection.UP)) continue;
                return true;
            }
        }
        return false;
    }

    public void func_71847_b(World world, int n, int n2, int n3, Random random) {
        this.func_71863_a(world, n, n2, n3, ForgeDirection.UNKNOWN.ordinal());
    }

    public void func_71863_a(World world, int n, int n2, int n3, int n4) {
        if (!this.func_71854_d(world, n, n2, n3)) {
            this.func_71897_c(world, n, n2, n3, world.func_72805_g(n, n2, n3), 0);
            world.func_94571_i(n, n2, n3);
        }
    }

    public boolean isBlockSolidOnSide(World world, int n, int n2, int n3, ForgeDirection forgeDirection) {
        return forgeDirection == ForgeDirection.UP || forgeDirection == ForgeDirection.DOWN;
    }
}

