/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.core;

import powercrystals.core.position.BlockPosition;

public class BlockPool {
    static BlockPool pool = new BlockPool(false);
    BlockNode head;
    BlockNode tail;
    private long size;
    private boolean _noDupe;

    public BlockPool(boolean bl) {
        this._noDupe = bl;
    }

    public BlockPool() {
        this(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BlockNode getNext(int n, int n2, int n3) {
        BlockNode blockNode;
        if (BlockPool.pool.head == null) {
            return new BlockNode(pool, n, n2, n3);
        }
        BlockPool blockPool = pool;
        synchronized (blockPool) {
            blockNode = pool.shift();
        }
        blockNode.reset(n, n2, n3);
        blockNode.next = null;
        blockNode.prev = null;
        return blockNode;
    }

    public void push(BlockNode blockNode) {
        if (this._noDupe) {
            BlockNode blockNode2 = this.tail;
            while (blockNode2 != null) {
                if (blockNode2.equals(blockNode)) {
                    blockNode.free();
                    return;
                }
                blockNode2 = blockNode2.prev;
            }
        }
        blockNode.prev = this.tail;
        blockNode.next = null;
        if (this.tail != null) {
            this.tail.next = blockNode;
        } else {
            this.head = blockNode;
        }
        this.tail = blockNode;
        ++this.size;
    }

    public BlockNode pop() {
        BlockNode blockNode = this.tail;
        if (blockNode != null) {
            this.tail = blockNode.prev;
            blockNode.prev = null;
            if (this.tail != null) {
                this.tail.next = null;
            } else {
                this.head = null;
            }
            --this.size;
        }
        return blockNode;
    }

    public BlockNode peek() {
        return this.tail;
    }

    public BlockNode poke() {
        return this.head;
    }

    public void unshift(BlockNode blockNode) {
        if (this._noDupe) {
            BlockNode blockNode2 = this.head;
            while (blockNode2 != null) {
                if (blockNode2.equals(blockNode)) {
                    blockNode.free();
                    return;
                }
                blockNode2 = blockNode2.next;
            }
        }
        blockNode.next = this.head;
        blockNode.prev = null;
        if (this.head != null) {
            this.head.prev = blockNode;
        } else {
            this.tail = blockNode;
        }
        this.head = blockNode;
        ++this.size;
    }

    public BlockNode shift() {
        BlockNode blockNode = this.head;
        if (blockNode != null) {
            this.head = blockNode.next;
            blockNode.next = null;
            if (this.head != null) {
                this.head.prev = null;
            } else {
                this.tail = null;
            }
            --this.size;
        }
        return blockNode;
    }

    public long size() {
        return this.size;
    }

    public static final class BlockNode {
        public BlockPosition bp;
        public BlockNode next;
        public BlockNode prev;
        BlockPool pool;

        public BlockNode(BlockPool blockPool, int n, int n2, int n3) {
            this.bp = new BlockPosition(n, n2, n3);
            this.pool = blockPool;
        }

        void reset(int n, int n2, int n3) {
            this.bp.x = n;
            this.bp.y = n2;
            this.bp.z = n3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void free() {
            BlockPool blockPool = this.pool;
            synchronized (blockPool) {
                this.pool.unshift(this);
            }
        }

        public boolean equals(Object object) {
            if (object == null || object.getClass() != BlockNode.class) {
                return false;
            }
            return this.bp.equals((Object)((BlockNode)object).bp);
        }

        public String toString() {
            return "BlockNode[" + this.bp + ";" + this.pool + "]";
        }

        public int hashCode() {
            return this.bp.hashCode();
        }
    }
}

