/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.api.MobDrop;
import powercrystals.minefactoryreloaded.core.GrindingDamage;
import powercrystals.minefactoryreloaded.core.HarvestAreaManager;
import powercrystals.minefactoryreloaded.core.ITankContainerBucketable;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryPowered;
import powercrystals.minefactoryreloaded.gui.container.ContainerFactoryPowered;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryPowered;
import powercrystals.minefactoryreloaded.world.GrindingWorldServer;

public class TileEntityGrinder
extends TileEntityFactoryPowered
implements ITankContainerBucketable {
    public static final int DAMAGE = 500000;
    private static Field recentlyHit;
    protected Random _rand;
    protected GrindingWorldServer _grindingWorld;
    protected GrindingDamage _damageSource;

    protected TileEntityGrinder(Machine machine) {
        super(machine);
        this._areaManager = new HarvestAreaManager(this, 2, 2, 1);
        this._rand = new Random();
        this.setManageSolids(true);
        this.setCanRotate(true);
    }

    public TileEntityGrinder() {
        this(Machine.Grinder);
        this._damageSource = new GrindingDamage();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiFactoryPowered(this.getContainer(inventoryPlayer), this);
    }

    @Override
    public ContainerFactoryPowered getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerFactoryPowered(this, inventoryPlayer);
    }

    public void func_70308_a(World world) {
        super.func_70308_a(world);
        if (this._grindingWorld != null) {
            this._grindingWorld.clearReferences();
            this._grindingWorld.setMachine(null);
        }
        if (this.field_70331_k instanceof WorldServer) {
            this._grindingWorld = new GrindingWorldServer((WorldServer)this.field_70331_k, this);
        }
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        if (this._grindingWorld != null) {
            this._grindingWorld.clearReferences();
            this._grindingWorld.setMachine(null);
        }
        this._grindingWorld = null;
    }

    public Random getRandom() {
        return this._rand;
    }

    @Override
    protected boolean shouldPumpLiquid() {
        return true;
    }

    @Override
    public int getWorkMax() {
        return 1;
    }

    @Override
    public int getIdleTicksMax() {
        return 200;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public boolean activateMachine() {
        this._grindingWorld.cleanReferences();
        var1_1 = this.field_70331_k.func_72872_a(EntityLivingBase.class, this._areaManager.getHarvestArea().toAxisAlignedBB());
        block0: for (E var3_3 : var1_1) {
            var4_4 = (EntityLivingBase)var3_3;
            if (var4_4 instanceof EntityAgeable && ((EntityAgeable)var4_4).func_70874_b() < 0 || var4_4.func_85032_ar() || var4_4.func_110143_aJ() <= 0.0f) continue;
            if (!MFRRegistry.getGrindables().containsKey(var4_4.getClass())) ** GOTO lbl-1000
            var5_5 = MFRRegistry.getGrindables().get(var4_4.getClass());
            var6_6 = var5_5.grind(var4_4.field_70170_p, var4_4, this.getRandom());
            if (var6_6 != null && var6_6.size() > 0 && WeightedRandom.func_76272_a((Collection)var6_6) > 0) {
                var7_7 = ((MobDrop)WeightedRandom.func_76271_a((Random)this._rand, (Collection)var6_6)).getStack();
                this.doDrop(var7_7);
            }
            if (var5_5.processEntity(var4_4)) {
                if (var4_4.func_110143_aJ() <= 0.0f) {
                    continue;
                }
            } else lbl-1000:
            // 3 sources

            {
                for (Object var6_6 : MFRRegistry.getGrinderBlacklist()) {
                    if (!var6_6.isInstance(var4_4)) continue;
                    continue block0;
                }
            }
            if (!this._grindingWorld.addEntityForGrinding((Entity)var4_4)) continue;
            this.damageEntity(var4_4);
            if (var4_4.func_110143_aJ() <= 0.0f) {
                this.fillTank(this._tanks[0], "mobessence", 1.0f);
                this.setIdleTicks(20);
            } else {
                this.setIdleTicks(10);
            }
            return true;
        }
        this.setIdleTicks(this.getIdleTicksMax());
        return false;
    }

    protected void setRecentlyHit(EntityLivingBase entityLivingBase, int n) {
        try {
            recentlyHit.set(entityLivingBase, n);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void damageEntity(EntityLivingBase entityLivingBase) {
        this.setRecentlyHit(entityLivingBase, 100);
        entityLivingBase.func_70097_a((DamageSource)this._damageSource, 500000.0f);
    }

    public int func_70302_i_() {
        return 0;
    }

    protected void fillTank(FluidTank fluidTank, String string, float f) {
        fluidTank.fill(FluidRegistry.getFluidStack((String)string, (int)((int)(100.0f * f))), true);
        this.func_70296_d();
    }

    @Override
    protected FluidTank[] createTanks() {
        return new FluidTank[]{new FluidTank(4000)};
    }

    public int fill(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        return 0;
    }

    public FluidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        for (FluidTank fluidTank : (FluidTank[])this.getTanks()) {
            if (fluidTank.getFluidAmount() <= 0) continue;
            return fluidTank.drain(n, bl);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        if (fluidStack != null) {
            for (FluidTank fluidTank : (FluidTank[])this.getTanks()) {
                if (!fluidStack.isFluidEqual(fluidTank.getFluid())) continue;
                return fluidTank.drain(fluidStack.amount, bl);
            }
        }
        return null;
    }

    @Override
    public boolean allowBucketDrain() {
        return true;
    }

    public boolean canFill(ForgeDirection forgeDirection, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection forgeDirection, Fluid fluid) {
        return true;
    }

    static {
        String[] stringArray = ObfuscationReflectionHelper.remapFieldNames((String)"net.minecraft.entity.EntityLivingBase", (String[])new String[]{"field_70718_bc", "recentlyHit"});
        recentlyHit = ReflectionHelper.findField(EntityLivingBase.class, (String[])stringArray);
    }
}

