/*
 * Decompiled with CFR 0.152.
 */
package skyboy.core.container;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import powercrystals.minefactoryreloaded.core.IUseHandler;
import skyboy.core.container.DefaultUseHandler;
import skyboy.core.fluid.LiquidRegistry;

public class CarbonContainer
extends ItemBucket {
    public static CarbonContainer cell;
    private static final DefaultUseHandler defaultUseAction;
    boolean canPlaceInWorld;
    boolean canBeFilledFromWorld;
    protected Item filledItem;
    protected Item emptyItem;
    protected int volume;
    protected Icon[] icons;
    protected List<IUseHandler> useHandlers;
    private boolean _prefix = false;

    public static void registerAsContainer(Fluid fluid) {
        FluidStack fluidStack = FluidRegistry.getFluidStack((String)fluid.getName(), (int)1000);
        fluidStack = fluidStack.copy();
        fluidStack.amount = CarbonContainer.cell.volume;
        FluidContainerRegistry.registerFluidContainer((FluidContainerRegistry.FluidContainerData)new FluidContainerRegistry.FluidContainerData(fluidStack, new ItemStack((Item)cell, 1, LiquidRegistry.getID(fluidStack)), new ItemStack((Item)cell, 1, 0)));
    }

    public CarbonContainer(int n, String string) {
        this(n, 64, string);
    }

    public CarbonContainer(int n, String string, int n2) {
        this(n, 64, string, n2);
    }

    public CarbonContainer(int n, int n2, String string) {
        this(n, n2, string, false);
    }

    public CarbonContainer(int n, int n2, String string, int n3) {
        this(n, n2, string, n3, false);
    }

    public CarbonContainer(int n, int n2, String string, boolean bl) {
        this(n, n2, string, 1000, bl);
    }

    public CarbonContainer(int n, int n2, String string, int n3, boolean bl) {
        super(n, 0);
        this.func_77625_d(n2);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77655_b(string);
        this.canBeFilledFromWorld = n3 >= 1000;
        this.canPlaceInWorld = bl && this.canBeFilledFromWorld;
        this.volume = n3;
        this.useHandlers = new LinkedList<IUseHandler>();
        this.useHandlers.add(defaultUseAction);
    }

    public Item func_77655_b(String string) {
        super.func_77655_b(string);
        GameRegistry.registerItem((Item)this, (String)this.func_77658_a());
        return this;
    }

    public CarbonContainer setFilledItem(Item item) {
        this.filledItem = item;
        return this;
    }

    public CarbonContainer setEmptyItem(Item item) {
        this.emptyItem = item;
        return this;
    }

    public boolean addUseHandler(IUseHandler iUseHandler) {
        return this.useHandlers.add(iUseHandler);
    }

    public boolean removeUseHandler(IUseHandler iUseHandler) {
        return this.useHandlers.remove(iUseHandler);
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer entityPlayer) {
        for (IUseHandler iUseHandler : this.useHandlers) {
            if (!iUseHandler.canUse(itemStack, (EntityLivingBase)entityPlayer)) continue;
            return iUseHandler.onTryUse(itemStack, world, (EntityLivingBase)entityPlayer);
        }
        return itemStack;
    }

    public boolean func_77875_a(World world, int n, int n2, int n3) {
        return false;
    }

    public ItemStack tryPlaceContainedLiquid(World world, ItemStack itemStack, int n, int n2, int n3, int n4) {
        ItemStack itemStack2;
        FluidStack fluidStack;
        if (world.field_72995_K) {
            return itemStack;
        }
        CarbonContainer carbonContainer = (CarbonContainer)itemStack.func_77973_b();
        int n5 = itemStack.func_77960_j();
        if (n5 != 0) {
            if (!carbonContainer.canPlaceInWorld) {
                return itemStack;
            }
            FluidStack fluidStack2 = LiquidRegistry.getLiquid(n5);
            if (world.func_72832_d(n, n2, n3, fluidStack2.getFluid().getBlockID(), 0, 3)) {
                return carbonContainer.getContainerItemStack(itemStack);
            }
            return itemStack;
        }
        if (!carbonContainer.canBeFilledFromWorld) {
            return itemStack;
        }
        int n6 = world.func_72798_a(n, n2, n3);
        Block block = Block.field_71973_m[n6];
        if (block instanceof IFluidBlock && (fluidStack = ((IFluidBlock)block).drain(world, n, n2, n3, false)) != null && FluidRegistry.isFluidRegistered((Fluid)fluidStack.getFluid()) && (itemStack2 = FluidContainerRegistry.fillFluidContainer((FluidStack)fluidStack, (ItemStack)itemStack)) != null && FluidContainerRegistry.isFilledContainer((ItemStack)itemStack2)) {
            ((IFluidBlock)block).drain(world, n, n2, n3, true);
            return itemStack2;
        }
        return itemStack;
    }

    public ItemStack func_77654_b(ItemStack itemStack, World world, EntityPlayer entityPlayer) {
        for (IUseHandler iUseHandler : this.useHandlers) {
            if (!iUseHandler.isUsable(itemStack)) continue;
            return iUseHandler.onUse(itemStack, (EntityLivingBase)entityPlayer);
        }
        return itemStack;
    }

    public EnumAction func_77661_b(ItemStack itemStack) {
        for (IUseHandler iUseHandler : this.useHandlers) {
            if (!iUseHandler.isUsable(itemStack)) continue;
            return iUseHandler.useAction(itemStack);
        }
        return EnumAction.none;
    }

    public int func_77626_a(ItemStack itemStack) {
        for (IUseHandler iUseHandler : this.useHandlers) {
            if (!iUseHandler.isUsable(itemStack)) continue;
            return iUseHandler.getMaxUseDuration(itemStack);
        }
        return 0;
    }

    public ItemStack setLiquid(ItemStack itemStack, FluidStack fluidStack, EntityPlayer entityPlayer) {
        CarbonContainer carbonContainer = (CarbonContainer)itemStack.func_77973_b();
        if (fluidStack == null || fluidStack.amount < carbonContainer.volume) {
            return itemStack;
        }
        int n = LiquidRegistry.getID(fluidStack);
        if (--itemStack.field_77994_a <= 0) {
            itemStack = new ItemStack(carbonContainer.filledItem, 1, n);
        } else {
            ItemStack itemStack2 = new ItemStack(carbonContainer.filledItem, 1, n);
            if (!entityPlayer.field_71071_by.func_70441_a(itemStack2)) {
                entityPlayer.func_71021_b(itemStack2);
            }
        }
        fluidStack.amount -= carbonContainer.volume;
        return itemStack;
    }

    public static ItemStack setLiquid(ItemStack itemStack, FluidStack fluidStack) {
        if (LiquidRegistry.getName(fluidStack) != null) {
            itemStack.field_77994_a = 1;
            itemStack.func_77964_b(LiquidRegistry.getID(fluidStack));
        }
        return itemStack;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister iconRegister) {
        this.icons = new Icon[2];
        this.icons[0] = iconRegister.func_94245_a("minefactoryreloaded:" + this.func_77658_a());
        this.icons[1] = iconRegister.func_94245_a("minefactoryreloaded:" + this.func_77658_a() + ".fill");
    }

    public FluidStack getLiquid(ItemStack itemStack) {
        CarbonContainer carbonContainer = (CarbonContainer)itemStack.func_77973_b();
        return LiquidRegistry.getLiquid(itemStack.func_77960_j(), carbonContainer.volume);
    }

    public String func_77667_c(ItemStack itemStack) {
        if (itemStack != null && itemStack.field_77993_c == this.filledItem.field_77779_bT && itemStack.func_77960_j() != 0) {
            return this.func_77658_a() + (this._prefix ? ".prefix" : ".suffix");
        }
        return this.func_77658_a();
    }

    public String getLocalizedName(String string) {
        String string2 = this.func_77658_a() + "." + string;
        if (StatCollector.func_94522_b((String)string2)) {
            return StatCollector.func_74838_a((String)string2);
        }
        return null;
    }

    public String func_77628_j(ItemStack itemStack) {
        int n = itemStack.func_77960_j();
        if (n != 0) {
            String string = LiquidRegistry.getName(n);
            String string2 = this.getLocalizedName(string);
            if (string2 != null && !string2.isEmpty()) {
                return EnumChatFormatting.RESET + string2 + EnumChatFormatting.RESET;
            }
            Fluid fluid = FluidRegistry.getFluid((String)string);
            if (fluid != null) {
                string = fluid.getLocalizedName();
            }
            this._prefix = true;
            string2 = super.func_77628_j(itemStack);
            this._prefix = false;
            string2 = string2 != null ? string2.trim() : "";
            string = (string2.isEmpty() ? "" : string2 + " ") + string;
            string2 = super.func_77628_j(itemStack);
            string2 = string2 != null ? string2.trim() : "";
            string = string + (string2.isEmpty() ? " " + this.getTranslatedBucketName() : " " + string2);
            return string;
        }
        return super.func_77628_j(itemStack);
    }

    protected String getTranslatedBucketName() {
        return Item.field_77788_aw.func_77628_j(FluidContainerRegistry.EMPTY_BUCKET);
    }

    public ItemStack getContainerItemStack(ItemStack itemStack) {
        if (itemStack.func_77960_j() != 0 && this.func_77634_r()) {
            return new ItemStack(this.func_77668_q(), 1, 0);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77633_a(int n, CreativeTabs creativeTabs, List list) {
        if (this.emptyItem.field_77779_bT == n) {
            list.add(new ItemStack(n, 1, 0));
        }
        if (this.filledItem.field_77779_bT == n) {
            int n2 = 0;
            int n3 = LiquidRegistry.getRegisteredLiquidCount();
            while (n2++ < n3) {
                list.add(new ItemStack(n, 1, n2));
            }
        }
    }

    public Icon getIcon(ItemStack itemStack, int n) {
        return this.icons[n];
    }

    MovingObjectPosition rayTrace(World world, EntityLivingBase entityLivingBase, boolean bl) {
        Vec3 vec3;
        MovingObjectPosition movingObjectPosition;
        float f = entityLivingBase.field_70125_A;
        float f2 = entityLivingBase.field_70177_z;
        double d = entityLivingBase.field_70163_u + (double)entityLivingBase.func_70047_e() - (double)entityLivingBase.field_70129_M;
        Vec3 vec32 = world.func_82732_R().func_72345_a(entityLivingBase.field_70165_t, d, entityLivingBase.field_70161_v);
        float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180)));
        float f6 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        double d2 = 5.0;
        if (entityLivingBase instanceof EntityPlayerMP) {
            d2 = ((EntityPlayerMP)entityLivingBase).field_71134_c.getBlockReachDistance();
        }
        if ((movingObjectPosition = world.func_72831_a(vec32, vec3 = vec32.func_72441_c((double)f7 * d2, (double)f6 * d2, (double)f8 * d2), bl, !bl)) != null && bl) {
            ForgeDirection forgeDirection = ForgeDirection.getOrientation((int)movingObjectPosition.field_72310_e);
            movingObjectPosition.field_72311_b += forgeDirection.offsetX;
            movingObjectPosition.field_72312_c += forgeDirection.offsetY;
            movingObjectPosition.field_72309_d += forgeDirection.offsetZ;
        }
        return movingObjectPosition;
    }

    static {
        defaultUseAction = new DefaultUseHandler();
    }
}

